﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke nact for aging

    .DESCRIPTION
        Run nact for start_aging_ssd CI job
#>

param
(
    [parameter(Mandatory=$true)]
    [string]
    # Path to NxAging config
    $ConfigPath
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\..\..\Modules\Error"
Import-Module "${scriptDirectoryPath}\..\..\Modules\Path"
Import-Module "${scriptDirectoryPath}\..\..\Modules\Utility"
Import-Module "${scriptDirectoryPath}\..\..\Modules\Yaml"
Import-Module "${scriptDirectoryPath}\..\..\Modules\NxAging"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Read configuration
$configText = (Get-Content $ConfigPath) -join [System.Environment]::NewLine
$config = (ConvertFrom-Yaml $configText).yaml

$BuildType              = $config.BuildType
$AdditionalBuildOptions = $env:ADDITIONAL_BUILD_OPTIONS -split ' '
$InitialImageName = ".*AutoTest"
foreach ($node in $config.AdditionalBuildOptions.ChildNodes)
{
    $AdditionalBuildOptions += $node.InnerXml
}


# NACT の引数
$arguments = @(
    "specs=NX",
    "platforms=NXFP2-a64",
    "outputs=default`",`"packages", # コンマ (,) は Invoke-Nact に渡す前にダブルクォートする必要がある
    "BUILD=${BuildType}",
    "-d", "Integrate/Packages/PackageDefinitions/NX/TargetTest",
    "-F", "HelloWorld.nsp",
    "-F", "SystemUpdaterHostFs.nsp",
    "-F", "DevMenuCommand.nsp",
    "-F", "DevMenuCommandSystem.nsp",
    "-F", "SettingsManager.nsp",
    "-F", "RecoveryWriter-K5-Hb-Unsigned.qspi.img",
    "-F", "RecoveryWriter-K5-Hb-Signed.qspi.img",
    "-F", "RecoverySystemPartitionWithUsb-P2Unsigned.fatimg",
    "-F", "RecoverySystemPartitionWithUsb-P2Signed.fatimg",
    "-F", "${InitialImageName}.initimg",
    "generate-debug-info=true",
    "--continue_on_error"
)

# nact 実行
Invoke-Expression "& `"${scriptDirectoryPath}\..\..\Invoke-Nact.ps1`" $(AdditionalBuildOptions -join ' ') $($arguments -join ' ')"

exit $LastExitCode
