﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Visual Studio Module

    .DESCRIPTION
        This file defines functions for Visual Studio operations
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

<#
    .SYNOPSIS
        Test if Visual Studio is runnning 

    .DESCRIPTION
        When Visual Studio is running, this function shows a dialog which requests to close all Visual Studio windows.
        If Visual Studio is not runnning or closed after showing dialog, this function returns $false.
        Otherwise, this function returns $true.
#>
function Test-VisualStudioRunning
{
    $expression = "cmd /c `"$(Get-NintendoSdkRootPath)\Integrate\Packages\InstallScript\VsiForNX\Scripts\check_vs_running.bat`""
    $output = Invoke-Expression $expression

    if ($LASTEXITCODE -eq 0)
    {
        return $false
    }
    else
    {
        return $true
    }
}
Export-ModuleMember -Function Test-VisualStudioRunning
