﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        USB Target Module

    .DESCRIPTION
        This file defines functions for USB Target operations
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

$ControlTargetPrivatePath = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ControlTargetPrivate.exe"

<#
    .SYNOPSIS
        Get a target name connected USB
#>
function Get-SigleUsbTargetName
{
    param
    (
        [Int]
        $RetryCount = 5
    )

    $retry = 1
    while ($retry -le $RetryCount) {
        $DetectTargetOutput = Invoke-Expression "& `"$ControlTargetPrivatePath`" detect-target"
        if(![String]::IsNullOrEmpty($DetectTargetOutput))
        {
            $TargetCount = (
                $DetectTargetOutput |
                Where-Object { $_ -match "NoIpAddress" } |
                ForEach-Object { $_ -replace "(\S*)\s*\S*","`$1"} |
                Tee-Object -Variable TargetName |
                Measure-Object
            ).Count
            if($TargetCount -ne 0)
            {
                break
            }
        }
        [System.Threading.Thread]::Sleep(100)
        $retry++
    }

    if($retry -eq $RetryCount)
    {
        throw "USB target not found."
    }

    if($LastExitCode -ne 0)
    {
        throw "Target enumeration failed. ExitCode = $LastExitCode"
    }

    if($TargetCount -ne 1)
    {
        Write-Output $EnumerateOutput
        throw "Failed to find single USB target. NumTarget = $TargetCount."
    }

    return $TargetName
}
Export-ModuleMember -Function Get-SigleUsbTargetName
