﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        NuGet Module

    .DESCRIPTION
        This file defines functions for NuGet operations
#>


$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

<#
    .SYNOPSIS
        Adds the specified nupkg to a package source.

    .PARAMETER packagePath
        Specified the nupkg to add.

    .PARAMETER source
        Specifies the package source.
#>
function Add-NuGetPackage
{
    param(
        [Parameter(Mandatory=$true, Position = 0)]
        [string]
        $packagePath,

        [Parameter(Mandatory=$true)]
        [string]
        $source
    )

    $nugetPath = Get-NuGetPath
    & $nugetPath add $packagePath -NonInteractive -Source $source

    if ($LastExitCode -ne 0)
    {
        throw "$nugetPath add $packagePath -NonInteractive -Source $source failed with exit code $LastExitCode."
    }
}
Export-ModuleMember -Function Add-NuGetPackage
