<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>
<#
    .SYNOPSIS
        GetR}hhttpT[o_E[h

    .PARAMETER WebClient
        httpʐMNX

    .PARAMETER UrlStr
        GetURL
#>
function Invoke-DownloadString
{
    param
    (
        $WebClient,
        $UrlStr
    )
    try{
        $DownloadStr = $WebClient.DownloadString($UrlStr)
        return $DownloadStr
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "teamcityƂ̒ʐMɎs܂: $exceptionDetails"
        exit 1
    }
}
Export-ModuleMember -Function Invoke-DownloadString

<#
    .SYNOPSIS
        teamcitỹT[oURL擾

    .PARAMETER ArgServerUrl
        rhXebv̈Ŏw肳ꂽT[oURL
#>
function Get-ServerUrl
{
    param
    (
        $ArgServerUrl
    )
    $ServerUrl = $ArgServerUrl
    if($ServerUrl -eq "" -or $ServerUrl -eq $null)
    {
        Write-Host "ServerUrl̎擾Ɏs܂"
        exit 1
    }
    return $ServerUrl
}
Export-ModuleMember -Function Get-ServerUrl

<#
    .SYNOPSIS
        2T̊JnrW擾

    .PARAMETER ArgMaxRevisionStr
        rhXebv̈Ŏw肳ꂽ2T̊JnrW
#>
function Get-EnvMaxRevision
{
    param
    (
        $ArgMaxRevisionStr
    )
    $MaxRevisionStr = $ArgMaxRevisionStr
    return $MaxRevisionStr
}
Export-ModuleMember -Function Get-EnvMaxRevision

<#
    .SYNOPSIS
        2T̏IrW擾

    .PARAMETER ArgMinRevisionStr
        rhXebv̈Ŏw肳ꂽ2T̏IrW
#>
function Get-EnvMinRevision
{
    param
    (
        $ArgMinRevisionStr
    )
    $MinRevisionStr = $ArgMinRevisionStr
    return $MinRevisionStr
}
Export-ModuleMember -Function Get-EnvMinRevision

<#
    .SYNOPSIS
        2Tʂ^Ot^ƂȂrhID擾

    .PARAMETER ArgOrientedBuildId
        rhXebv̈Ŏw肳ꂽ2Tʂ^Ot^ƂȂrhID
#>
function Get-OrientedBuildId
{
    param
    (
        $ArgOrientedBuildId
    )
    $OrientedBuildId = $ArgOrientedBuildId
    return $OrientedBuildId
}
Export-ModuleMember -Function Get-OrientedBuildId

<#
    .SYNOPSIS
        WusAgent擾

    .PARAMETER ArgAgentName
        rhXebv̈Ŏw肳ꂽWusAgent
#>
function Get-AgentName
{
    param
    (
        $ArgAgentName
    )
    $AgentName = $ArgAgentName
    if($AgentName -eq "" -or $AgentName -eq $null)
    {
        Write-Host "AgentName̎擾Ɏs܂"
        exit 1
    }
    return $AgentName
}
Export-ModuleMember -Function Get-AgentName

<#
    .SYNOPSIS
        F؃t@C擾

    .PARAMETER ArgAuthenticationFile
        rhXebv̈Ŏw肳ꂽF؃t@C
#>
function Get-AuthenticationFile
{
    param
    (
        $ArgAuthenticationFile
    )
    $AuthenticationFile = $ArgAuthenticationFile
    if($AuthenticationFile -eq "" -or $AuthenticationFile -eq $null)
    {
        Write-Host "ϐenv.SIGLO_AUTHENTICATION_FILEݒ肵Ă"
        exit 1
    }

    $result = Test-Path $AuthenticationFile
    if( $result -eq $false)
    {
        Write-Host "$AuthenticationFile ݂܂"
        exit 1
    }
    return $AuthenticationFile
}

<#
    .SYNOPSIS
        REST APIpID/PASSSystem.Net.NetworkCredentialNX𐶐

    .PARAMETER ArgAuthenticationFile
        F؃t@C
#>
function Get-NetworkCredential
{
    param
    (
        $ArgAuthenticationFile
    )
    $AuthenticationFile = Get-AuthenticationFile $ArgAuthenticationFile
    try
    {
        [xml]$Config = Get-Content $AuthenticationFile
        $UserName = $Config.Configuration.User
        $Password = $Config.Configuration.Password
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "[U^pX[h̎擾Ɏs܂"
        exit 1
    }

    if($UserName -eq "" -or $UserName -eq $null)
    {
        Write-Host "[U^pX[h̎擾Ɏs܂: [UȂ"
        exit 1
    }

    if($Password -eq "" -or $Password -eq $null)
    {
        Write-Host "[U^pX[h̎擾Ɏs܂: pX[hȂ"
        exit 1
    }

    $NetworkCredential = New-Object System.Net.NetworkCredential($UserName, $Password)
    return  $NetworkCredential
}
Export-ModuleMember -Function Get-NetworkCredential

<#
    .SYNOPSIS
        PostR}hhttpT[o֏𑗐M

    .PARAMETER HttpUrl
        PostURL

    .PARAMETER XmlOuterXml
        MXMLf[^

    .PARAMETER ArgAuthenticationFile
        F؃t@C
#>
function Invoke-Posthttp
{
    param
    (
        $HttpUrl,
        $XmlOuterXml,
        $ArgAuthenticationFile
    )
    try
    {
        $WebRequest = [System.Net.WebRequest]::Create($HttpUrl)
        $WebRequest.ContentType = "application/xml"
        $PostStr = [System.Text.Encoding]::UTF8.GetBytes($XmlOuterXml)
        $WebRequest.ContentLength = $PostStr.Length
        $WebRequest.ServicePoint.Expect100Continue = $false
        $WebRequest.Credentials = Get-NetworkCredential $ArgAuthenticationFile
        $WebRequest.PreAuthenticate = $true
        $WebRequest.Method = "POST"
        $RequestStream = $WebRequest.GetRequestStream()
        $RequestStream.Write($PostStr, 0,$PostStr.length)
        $RequestStream.Close()
        $Response = $WebRequest.GetResponse()
        $Response = $Response.GetResponseStream()
        $StreamReader = New-Object System.IO.StreamReader($Response)
        $PostResults = $StreamReader.ReadToEnd()
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "teamcityƂ̒ʐMɎs܂: $exceptionDetails"
        exit 1
    }
}
Export-ModuleMember -Function Invoke-Posthttp

<#
    .SYNOPSIS
        Wusʂ̎擾

    .PARAMETER WebClient
        httpʐMpNX

    .PARAMETER BuildConfName
        Wu

    .PARAMETER ArgServerUrl
        teamcitỹT[oURL

    .PARAMETER BuildId
        rhID

    .PARAMETER CurrentBranch
        rhu`
#>
function Get-CurrentJobResult
{
    param
    (
        $WebClient,
        $BuildConfName,
        $ArgServerUrl,
        $BuildId,
        $CurrentBranch
    )

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $BuildResultUrl = "$ServerUrl/httpAuth/app/rest/builds/?locator=buildType:$BuildConfName,branch:$CurrentBranch,id:$BuildId&fields=build(status)";
    Write-Host "BUILD_RESULT_URL: $BuildResultUrl"

    # Wusʂ̎擾

    $BuildResultStr = Invoke-DownloadString $WebClient $BuildResultUrl
    try
    {
        $XmlBuildResult = [xml]$BuildResultStr
        $CurrentJobResult = $XmlBuildResult.builds.build.GetAttribute("status")
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "rhʎ擾Ɏs܂: $BuildResultStr $exceptionDetails"
        exit 1
    }
    if($CurrentJobResult -eq "" -or $CurrentJobResult -eq $null)
    {
        Write-Host "rȟʎ擾Ɏs܂"
        exit 1
    }

    return $CurrentJobResult
}
Export-ModuleMember -Function Get-CurrentJobResult
