﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    .NET ツール用ローカライズファイルをコピーします。

    .DESCRIPTION
    .NET ツール用ローカライズファイルをコピーします。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    # 翻訳用リポジトリのルートを指定します。
    [parameter(Mandatory = $true,
               Position = 0)]
    [string] $TranslationRoot
)

$sigloRoot = (Join-Path $MyInvocation.MyCommand.Path ../../../.. | Resolve-Path).Path

"ja","en" |
ForEach-Object {
    $slang = $_

    $srcRoot = Join-Path $TranslationRoot $slang/Resources/Tools | Convert-Path

    Get-ChildItem $srcRoot -Recurse |
    Where-Object { ! $_.PSIsContainer } |
    ForEach-Object {
        $relPath = $_.DirectoryName.Substring($srcRoot.Length + 1)
        if ($relPath -notmatch '^ToolFoundation\\') {
            $dstRelPath = $relPath -replace '^((Programs\\)?[^\\]+)','$1/Intermediates/Localization'
            $dstDir = mkdir $sigloRoot/$dstRelPath/$slang -Force
            Copy-Item $_.FullName $dstDir.FullName
        }
    }
}
