﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke StyleCop

    .DESCRIPTION
        Run StyleCop against C# Projects in NintendoSDK

    .INPUTS
        ./StyleCop/StyleCop.proj
        ./StyleCop/StyleCop.Targets
        *.cs file of C# project
#>
$ScriptPath = $MyInvocation.MyCommand.Path
$ScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($ScriptPath)

Import-Module "${ScriptDirectoryPath}\Modules\Error"
Import-Module "${ScriptDirectoryPath}\Modules\Path"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$ExitValue = 0

Get-ChildItem $(Get-NintendoSdkRootPath) -Recurse -Name -include *.csproj | % {
    $path = $_

    # Externals は外部コードがあるため除外
    if($path.StartsWith("Externals"))
    {
        return;
    }

    $env:CsProjectDirectoryPath = "$(Get-NintendoSdkRootPath)\$(Split-Path -Parent $path)"

    Invoke-Expression "& $(Get-MSBuildX64Path) $(Get-NintendoSdkIntegrateRootPath)\Resources\Scripts\StyleCop\StyleCop.proj /t:StyleCop"

    if($LastExitCode -ne 0)
    {
        $ExitValue = 1
    }
}

exit $ExitValue
