﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke Nact

    .DESCRIPTION
        Setting environment variables, run nact.

    .INPUTS
        Command-Line Options for nact
#>
param
(
    [switch]
    $LocalExecutionMode
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$env:PATH = "$(Get-NintendoSdkCommandLineToolsRootPath);${env:PATH}"

if ( -not (Test-Path "env:\NACT_EXECUTEPARALLEL") )
{
    # 全プロセッサの合計論理コア数を並列数とする
    ${env:NACT_EXECUTEPARALLEL} = (Get-WmiObject -Class Win32_Processor | Measure-Object -Property NumberOfLogicalProcessors -Sum).Sum
}

$argsFromScript = New-Object "System.Collections.Generic.List[string]"

$argsFromScript.Add("-m")
$argsFromScript.Add("-j")
$argsFromScript.Add(${env:NACT_EXECUTEPARALLEL})

$argsFromScript.Add("--log_file")
$argsFromScript.Add(".ci\Artifacts\nact_log_" + (Get-Date).ToString("yyyyMMdd_HHmmss_fff") + ".yml")

$argsFromScript.Add("--print_stage")
$argsFromScript.Add("--print_eval_trace")

# 出力するメッセージを英語に
$argsFromScript.Add("--ui_culture")
$argsFromScript.Add("en")

if(-not $LocalExecutionMode)
{
    $argsFromScript.Add("--print_time_summary")
    $argsFromScript.Add("--print_time_detail")
    $argsFromScript.Add("--print_build_log_summary")
    $argsFromScript.Add("--replay_action_log")
    $argsFromScript.Add("--print_teamcity_build_problems")

    # 30秒毎に進捗を表示
    $argsFromScript.Add("--print_progress")
    $argsFromScript.Add("30")

    # --no_launch_server_process: サーバプロセスが残ってしまわないようにするため、 CI ビルドではサーバプロセスを使用しないようにする
    $argsFromScript.Add("--no_launch_server_process")

    # SIGLO-83476: FileTracker.dll を注入すると動作が不安定となる場合があるため Tracker.exe を使用する
    $argsFromScript.Add("--experimental_track_method")
    $argsFromScript.Add("TrackerExe")
}

& (Get-NactPath) @argsFromScript @args

exit $LastExitCode
