﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS

    .DESCRIPTION

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>

[CmdletBinding()]
Param(
    # 認証情報が書かれた設定ファイルを指定します
    [parameter(Mandatory = $true)]
    [string]$AuthenticationFile,

    # エクスポートするConfluenceのスペースキーを指定します。
    [parameter()]
    [string]$ConfluenceSpaceKey,

    # エクスポートしたConfluenceのファイル名のベース部分を指定します。
    [parameter()]
    [string]$ConfluenceExportFileBaseName = "Confluence-space"
)

$ErrorActionPreference = "Stop"

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

Import-Module $scriptDir/Modules/Error
Import-Module $scriptDir/Modules/Path

$sigloRoot = (Resolve-Path $scriptDir/../..).Path

$documentsRoot = Get-NintendoSdkDocumentsRootPath
$documentsOutputs = Join-Path $documentsRoot Outputs
$documentsIntermediates = Join-Path $documentsRoot Intermediates

# Confluenceのエクスポート
& $sigloRoot/Integrate/Scripts/Export-ConfluenceSpace.ps1 `
    -AuthenticationFile $AuthenticationFile `
    -SpaceKey $ConfluenceSpaceKey
if ($LastExitCode) {
    throw "Export-ConfluenceSpace failed. - $LastExitCode"
}
    
# ダウンロードした zip を展開
$unzipDir = Join-Path $documentsIntermediates Confluence/$ConfluenceSpaceKey
& (Get-7ZipPath) x "$documentsOutputs/$ConfluenceExportFileBaseName-$ConfluenceSpaceKey.zip" "-o$unzipDir" -y |
Where-Object { $_ -notmatch '^Extracting ' }

if ($LastExitCode) {
    throw "7-Zip failed. - $LastExitCode"
}
