<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>
Param
(
    $ArgServerUrl,
    $ArgMaxRevisionStr,
    $ArgMinRevisionStr,
    $ArgOrientedBuildId,
    $ArgAgentName,
    $ArgAuthenticationFile,
    $ArgBuildConfName,
    $ArgBuildId,
    $ArgBuildTypeId,
    $ArgCurrentRevision,
    $ArgCurrentBranch
)

#ʊ֐̃[h
$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\Modules\ErrorCommitRevisionFunctions"

<#
    .SYNOPSIS
        rhWu擾
#>
function Get-BuildConfName
{
    $BuildConfName = $ArgBuildConfName
    if($BuildConfName -eq "" -or $BuildConfName -eq $null)
    {
        Write-Host "BuildConfName̎擾Ɏs܂"
        exit 1
    }
    return $BuildConfName
}

<#
    .SYNOPSIS
        rhID擾
#>
function Get-BuildId
{
    $BuildId = $ArgBuildId
    if($BuildId -eq "" -or $BuildId -eq $null)
    {
        Write-Host "BuildId̎擾Ɏs܂"
        exit 1
    }
    return $BuildId
}

<#
    .SYNOPSIS
        WuTypeID擾
#>
function Get-BuildTypeId
{
    $BuildTypeId = $ArgBuildTypeId
    if($BuildTypeId -eq "" -or $BuildTypeId -eq $null)
    {
        Write-Host "BuildTypeId̎擾Ɏs܂"
        exit 1
    }
    return $BuildTypeId
}

<#
    .SYNOPSIS
        rh̃rW擾
#>
function Get-CurrentRevision
{
    $CurrentRevision = $ArgCurrentRevision
    if($CurrentRevision -eq "" -or $CurrentRevision -eq $null)
    {
        Write-Host "CurrentRevision̎擾Ɏs܂"
        exit 1
    }
    return $CurrentRevision
}

<#
    .SYNOPSIS
        rh̃u`擾
#>
function Get-CurrentBranch
{
    if($ArgCurrentBranch -eq "" -or $ArgCurrentBranch -eq $null)
    {
        Write-Host "CurrentBranch̎擾Ɏs܂"
        exit 1
    }
    $CurrentBranch = $ArgCurrentBranch.Replace("refs/heads/", "")
    $CurrentBranch = $CurrentBranch.Replace("feature/", "")
    if($CurrentBranch -eq "" -or $CurrentBranch -eq $null)
    {
        Write-Host "CurrentBranch̎擾Ɏs܂"
        exit 1
    }
    return $CurrentBranch
}

<#
    .SYNOPSIS
        2Tsp̃LbN

    .PARAMETER WebClient
        httpʐMNX
#>
function Queue-BisectJob
{
    Param
    (
        $WebClient
    )
    $MaxRevisionStr = Get-EnvMaxRevision $ArgMaxRevisionStr
    $MinRevisionStr = Get-EnvMinRevision $ArgMinRevisionStr
    $OrientedBuildId = Get-OrientedBuildId $ArgOrientedBuildId
    $CurrentBranch = Get-CurrentBranch
    $CurrentBuildId = Get-BuildId

    $AgentName = Get-AgentName $ArgAgentName

    #ԃo[WŃrh{
    $Xml = New-Object System.Xml.XmlDocument
    $build = $Xml.CreateElement("build")
    $build.SetAttribute("branchName", $CurrentBranch)
    $buildType = $Xml.CreateElement("buildType")
    $buildType.SetAttribute("id", "SigloSdk_Nx_Public_ESOL_run_binary_search")
    $build.AppendChild($buildType)
    $properties = $Xml.CreateElement("properties")
    $propertyMaxRevision = $Xml.CreateElement("property")
    $propertyMaxRevision.SetAttribute("name", "env.SPECIFY_MAX_REVISION")
    $propertyMaxRevision.SetAttribute("value", $MaxRevisionStr)
    $properties.AppendChild($propertyMaxRevision)
    $propertyMinRevision = $Xml.CreateElement("property")
    $propertyMinRevision.SetAttribute("name", "env.SPECIFY_MIN_REVISION")
    $propertyMinRevision.SetAttribute("value", $MinRevisionStr)
    $properties.AppendChild($propertyMinRevision)
    $propertyOrientedBuildId = $Xml.CreateElement("property")
    $propertyOrientedBuildId.SetAttribute("name", "env.SPECIFY_ORIENTED_BUILDID")
    $propertyOrientedBuildId.SetAttribute("value", $OrientedBuildId)
    $properties.AppendChild($propertyOrientedBuildId)
    $propertyCurrentBuildId = $Xml.CreateElement("property")
    $propertyCurrentBuildId.SetAttribute("name", "env.SPECIFY_CURRENT_BUILD_ID")
    $propertyCurrentBuildId.SetAttribute("value", $CurrentBuildId)
    $properties.AppendChild($propertyCurrentBuildId)
    $propertyAgent = $Xml.CreateElement("property")
    $propertyAgent.SetAttribute("name", "env.SPECIFY_AGENT")
    $propertyAgent.SetAttribute("value", $AgentName)
    $properties.AppendChild($propertyAgent)
    $build.AppendChild($properties)
    $Xml.AppendChild($build)
    Write-Host $Xml.OuterXml

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $QueueUrl = "$ServerUrl/httpAuth/app/rest/buildQueue/"
    Write-Host $QueueUrl
    Invoke-Posthttp $QueueUrl $Xml.OuterXml $ArgAuthenticationFile
}

# ܂ŃTu֐
# ||||||||||||||||

# C̃vOt[

Write-Host $ArgServerUrl
Write-Host $ArgMaxRevisionStr
Write-Host $ArgMinRevisionStr
Write-Host $ArgOrientedBuildId
Write-Host $ArgAgentName
Write-Host $ArgAuthenticationFile
Write-Host $ArgBuildConfName
Write-Host $ArgBuildId
Write-Host $ArgBuildTypeId
Write-Host $ArgCurrentRevision
Write-Host $ArgCurrentBranch

# REST APIID/PASS̎擾āAhttpʐMpWebClient̍쐬
$NetworkCredential = Get-NetworkCredential $ArgAuthenticationFile
$WebClient = New-Object System.Net.WebClient
$WebClient.Credentials = $NetworkCredential
$WebClient.Encoding = [System.Text.Encoding]::UTF8

# Wusʂ̎擾
$BuildConfName = Get-BuildConfName
$BuildId = Get-BuildId
$CurrentBranch = Get-CurrentBranch
$CurrentJobResult = Get-CurrentJobResult $WebClient $BuildConfName $ArgServerUrl $BuildId $CurrentBranch

$OrientedBuildId = Get-OrientedBuildId $ArgOrientedBuildId
# 񂩁H
if($OrientedBuildId -eq "")
{
    # YES

    #Wus
    if($CurrentJobResult -eq "SUCCESS")
    {
        # 
        exit 0
    }
}

# L[̑M
Queue-BisectJob $WebClient

