<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Copy TargetFrameworkAttributeFiles

    .DESCRIPTION
        Copying .NETFramework attribute files to the TEMP directory.
        This is a workaround for nact to enable parallel MSBuild execution.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$errorCount = $error.count
$temporaryDirectoryPath = [System.IO.Path]::GetTempPath()

foreach ($file in (Get-TargetFrameworkAttributeFiles))
{
    Copy-Item $file $temporaryDirectoryPath
}

if ($error.count -eq $errorCount)
{
    exit 0
}
else
{
    exit 1
}
