:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

setlocal

set SCRIPT_DIRECTORY=%~dp0
set REPOSITORY_ROOT=%~dp0\..\..\..\..\
set DOT_GIT_DIRECTORY=%REPOSITORY_ROOT%.git\

:: ---------------------------------------------------------------------------
:: Setup SSH
:: ---------------------------------------------------------------------------

if not defined HOME (
    set HOME=%HOMEDRIVE%%HOMEPATH%
)

findstr spdlybra.nintendo.co.jp "%HOME%\.ssh\known_hosts" 2> nul > nul
if %ERRORLEVEL% == 0 (
    goto success
)

if defined GIT_SSH (
    if exist "%GIT_SSH%" (
        goto success
    ) else (
        echo "ERROR: GIT_SSH is invalid.(%GIT_SSH%)" 1>&2
        goto error
    )
)

:set_git_ssh
echo GIT_SSH is not set yet. 

call "%SCRIPT_DIRECTORY%getAtlassianVars.cmd"
set PLINK=%SOURCETREE_DIRECTORY%tools\putty\plink.exe

if exist %PLINK% (
    echo "plink.exe is found. (%PLINK%)"
    set /p yesno="  Do you wish to register the environment variable GIT_SSH?(y/n):"
    if "%yesno%" == "y" (
        setx GIT_SSH "%PLINK%"
        echo Please restart bat file to apply change.
        pause
        exit
    )
)

echo ERROR: Please setup GIT_SSH manually.

:error
exit /B 1

:success

