:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

setlocal

set SCRIPT_DIRECTORY=%~dp0
set REPOSITORY_ROOT=%~dp0\..\..\..\..\
set DOT_GIT_DIRECTORY=%REPOSITORY_ROOT%.git\

:: ---------------------------------------------------------------------------
:: Setup GitExternalRepository.
:: ---------------------------------------------------------------------------
echo Setup GitExternalRepository.

set EXREPO_SRC_DIRECTORY=%SCRIPT_DIRECTORY%
set EXREPO_DEST_DIRECTORY=%DOT_GIT_DIRECTORY%GitExternalRepository

if not exist "%EXREPO_DEST_DIRECTORY%" (
    mkdir "%EXREPO_DEST_DIRECTORY%"
)
xcopy /q /y /i "%EXREPO_SRC_DIRECTORY%GitExternalRepository.exe"    "%EXREPO_DEST_DIRECTORY%" >nul
xcopy /q /y /i "%EXREPO_SRC_DIRECTORY%System.Interactive.dll"       "%EXREPO_DEST_DIRECTORY%" >nul
xcopy /q /y /i "%EXREPO_SRC_DIRECTORY%ToolFoundation.dll"           "%EXREPO_DEST_DIRECTORY%" >nul

:: ---------------------------------------------------------------------------
:: Setup .git/config settings.
:: ---------------------------------------------------------------------------
echo Setup .git/config settings.
:: set command alias
git config alias.exrepo "!.git/GitExternalRepository/GitExternalRepository.exe"
:: set shortcut aliases
git config alias.exforeach "!git config -l|sed -rn 's/.*exrepo\.(Externals\/[^.]*).*/\1/p'|xargs -I{} sh -c "
git config alias.exstatus "!echo -e 'Current commit:' && git --no-pager log -1 --pretty=short && echo -e '\nMain repo & submodule status:\n' && git status && echo -e '\nExrepo statuses:' && git exforeach 'echo && echo {} && echo HEAD at: && git -C {} rev-parse HEAD && echo Expected: && git grep --cached -A 2 -h {} -- .exrepomodules | sed -n -e s/^.*revision.=.//p && echo Status: && git -C {} status'"
git config alias.exstash "!echo 'Stashing all changes...' && git stash -u && git submodule foreach --recursive 'git stash -u' && git exforeach 'echo {} && git -C {} stash -u' && git exclean"
git config alias.exclean "!echo 'Cleaning all changes...' && git exupdate && git reset --hard && git clean -fd && git submodule foreach --recursive 'git reset --hard && git clean -fd' && git exforeach 'git -C {} reset --hard && git -C {} clean -fd'"
git config alias.excleanignored "!echo 'Cleaning all changes and removing ignored files...' && git exupdate && git reset --hard && git clean -fdx && git reset --hard && git submodule foreach --recursive 'git reset --hard && git clean -fdx' && git exforeach 'git -C {} reset --hard && git -C {} clean -fdx'"
git config alias.excleandelete "!echo 'Cleaning all changes and removing ignored files, repositories, and caches...' && rm -rf .git/GitExternalStorage/Cache && rm -rf .git/exrepo && git reset --hard && git clean -ffdx && git reset --hard && git exupdate"
git config alias.exupdate "!echo 'Updating submodules & exrepos...' && git submodule update --init --recursive --force && git exrepo deinit -a && git exrepo-m init && git exrepo delete-unused-repository && git exrepo update --force && git exstorage expand"

:: ---------------------------------------------------------------------------
:: Setup OpenSSH
:: ---------------------------------------------------------------------------
echo Setup OpenSSH settings.
call "%SCRIPT_DIRECTORY%setupSsh.cmd"
