:: ---------------------------------------------------------------------------
::  Copyright (C)Nintendo All rights reserved.
::
::  These coded instructions, statements, and computer programs contain proprietary
::  information of Nintendo and/or its licensed developers and are protected by
::  national and international copyright laws. They may not be disclosed to third
::  parties or copied or duplicated in any form, in whole or in part, without the
::  prior written consent of Nintendo.
::
::  The content herein is highly confidential and should be handled accordingly.
:: ---------------------------------------------------------------------------

@echo off

setlocal

echo Setup Git Hook Scripts for cpplint

:: ---------------------------------------------------------------------------
:: Check git directories
:: ---------------------------------------------------------------------------
set REPOSITORY_ROOT=%~dp0..\..\..\..\

set GIT_DIRECTORY=%REPOSITORY_ROOT%.git\
if not exist "%GIT_DIRECTORY%" goto :error_no_git_directory

set GIT_HOOK_DIRECTORY=%GIT_DIRECTORY%hooks\
if not exist "%GIT_HOOK_DIRECTORY%" mkdir "%GIT_HOOK_DIRECTORY%"

:: ---------------------------------------------------------------------------
:: Install git hook scripts for cpplint
:: ---------------------------------------------------------------------------
call :install ^
    "%~dp0pre-commit.cpplint"

if ERRORLEVEL 1 goto error_copy_failed

:: ---------------------------------------------------------------------------
:: Success and exit
:: ---------------------------------------------------------------------------
exit /b 0

:: ---------------------------------------------------------------------------
:: Error and exit
:: ---------------------------------------------------------------------------
:error_no_git_directory
echo ASSERTION FAILURE: Git directory not found.
exit /b 1

:error_copy_failed
echo ASSERTION FAILURE: Failed to copy git hook script files into %GIT_HOOK_DIRECTORY%.
exit /b 1

:: ---------------------------------------------------------------------------
:: Procedures
:: ---------------------------------------------------------------------------
:install
for %%I in (%*) do (
    xcopy /b /i /y /q %%I %GIT_HOOK_DIRECTORY% >nul
    if ERRORLEVEL 1 exit /b 1
)
exit /b 0

