﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/istorage/storage.h>

namespace nn { namespace escore {

MemoryInputStream::MemoryInputStream(const void *buffer, u32 size)
{
    rBuf = (const u8 *)buffer;
    rSize = size;
    rPos = 0;
}


MemoryInputStream::~MemoryInputStream()
{
    /* Do nothing */
}


Result MemoryInputStream::TryRead(s32 *pOut, void *buffer, u32 size)
{
    RESULT_NAMESPACE::Result res;
    u32 bytes;

    res.Set(0);

    if (rPos + size > rSize) {
        bytes = (u32)(rSize - rPos);
    }
    else {
        bytes = size;
    }

    memcpy(buffer, &rBuf[rPos], bytes);
    *pOut = (s32)bytes;
    rPos += bytes;

    return res;
}


Result MemoryInputStream::TrySetPosition(s64 position)
{
    RESULT_NAMESPACE::Result res;

    res.Set(0);

    if (position >= rSize) {
        res.Set(-1);
        goto end;
    }
    else {
        rPos = position;
    }

end:
    return res;
}


Result MemoryInputStream::TryGetPosition(s64 *pOut) const
{
    RESULT_NAMESPACE::Result res;

    res.Set(0);

    *pOut = rPos;

    return res;
}


Result MemoryInputStream::TryGetSize(s64 *pOut) const
{
    RESULT_NAMESPACE::Result res;

    res.Set(0);

    *pOut = rSize;

    return res;
}

}}
