﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


#include <nn/escore/escore.h>
#include <nn/iosc/iosc.h>

#if defined(GVM) && !defined(CPP_ES)
#include <es.hpp>
#endif

USING_ES_NAMESPACE
USING_ISTORAGE_NAMESPACE

#include "es_container.h"
#include "es_storage.h"

#ifndef UNUSED
#define UNUSED(x)   (void)(x)
#endif

ES_NAMESPACE_START


static bool s_Initialized = false;

static IInputStream *s_Ticket;

static u8 s_Buf[SIZE_SHA_ALIGN(sizeof(ESV2Ticket))]
                ATTR_SHA_ALIGN;
static ESV2Ticket * const s_Tp = (ESV2Ticket *) s_Buf;

static const void **s_Certs = NULL;
static u32 s_NCerts = 0;

static bool s_DoVerify = true;

ETicket::ETicket()
{
#if !defined(ES_READ_ONLY)
    IOSC_Initialize();
#endif  // ES_READ_ONLY
}


ETicket::~ETicket()
{
    s_Initialized = false;
}


ESError
ETicket::Set(IInputStream &ticket, const void *certs[], u32 nCerts,
             bool doVerify)
{
    ESError rv = ES_ERR_OK;

#if defined(ES_READ_ONLY)
    if (doVerify) {
        esLog(ES_DEBUG_ERROR, "Cannot verify ticket in read-only mode\n");
        rv = ES_ERR_INVALID;
        goto end;
    }
#endif  // ES_READ_ONLY

    if (doVerify && (!certs || nCerts == 0)) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    if ((rv = esVerifyTicket(ticket, certs, nCerts, doVerify, NULL, NULL, s_Buf)) != ES_ERR_OK) {
        goto end;
    }

    s_Ticket = &ticket;
    s_Certs = certs;
    s_NCerts = nCerts;
    s_DoVerify = doVerify;
    s_Initialized = true;

end:
    return rv;
}


ESError
ETicket::GetSize(u32 *outSize)
{
    ESError rv = ES_ERR_OK;

    if (outSize == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outSize = sizeof(ESV2Ticket) + s_Tp->sectTotalSize;

end:
    return rv;
}


ESError
ETicket::GetTitleKeyType( ESTitleKeyType *outTitleKeyType )
{
    ESError rv = ES_ERR_OK;

    if ( outTitleKeyType == NULL || !s_Initialized ) {
        esLog( ES_DEBUG_ERROR, "Invalid arguments or state\n" );
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outTitleKeyType = s_Tp->titleKeyType;

end:
    return rv;
}


ESError
ETicket::GetTitleKey( ESTitleKey *outTitleKey )
{
    ESError rv = ES_ERR_OK;

    if ( outTitleKey == NULL || !s_Initialized ) {
        esLog( ES_DEBUG_ERROR, "Invalid arguments or state\n" );
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outTitleKey = s_Tp->titleKey;

end:
    return rv;
}


ESError
ETicket::GetTicketId(ESTicketId *outTicketId)
{
    ESError rv = ES_ERR_OK;

    if (outTicketId == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outTicketId = s_Tp->ticketId;

end:
    return rv;
}


ESError
ETicket::GetTicketVersion(ESTicketVersion *outTicketVersion)
{
    ESError rv = ES_ERR_OK;

    if (outTicketVersion == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outTicketVersion = s_Tp->ticketVersion;

end:
    return rv;
}


ESError
ETicket::GetRightsId(ESRightsId *outRigthsId)
{
    ESError rv = ES_ERR_OK;

    if (outRigthsId == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    memcpy(outRigthsId, s_Tp->rightsId, sizeof(ESRightsId));

end:
    return rv;
}


ESError
ETicket::GetDeviceId(ESDeviceId *outDeviceId)
{
    ESError rv = ES_ERR_OK;

    if (outDeviceId == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outDeviceId = s_Tp->deviceId;

end:
    return rv;
}

ESError
ETicket::GetAccountId(ESAccountId *outAccountId)
{
    ESError rv = ES_ERR_OK;

    if (outAccountId == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outAccountId = s_Tp->accountId;

end:
    return rv;
}

ESError
ETicket::GetPreInstallationFlag(bool *outFlag)
{
    ESError rv = ES_ERR_OK;

    if (outFlag == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outFlag = (ntohs(s_Tp->propertyMask) & ES_TICKET_PRE_INSTALL_FLAG) != 0;

end:
    return rv;
}


ESError
ETicket::GetLicenseType(ESLicenseType *outLicenseType)
{
    ESError rv = ES_ERR_OK;

    if (outLicenseType == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outLicenseType = s_Tp->licenseType;

end:
    return rv;
}

ESError
ETicket::GetIssuerName(u8 *outIssuer)
{
    ESError rv = ES_ERR_OK;

    if (outIssuer == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    memcpy(outIssuer, s_Tp->sig.issuer, 64);
end:
    return rv;
}

ESError
ETicket::GetCommonKeyId(u8 *outCommonKeyId)
{
    ESError rv = ES_ERR_OK;

    if (outCommonKeyId == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outCommonKeyId = s_Tp->commonKeyId;
end:
    return rv;
}

ESError
ETicket::GetPropertyMask(u16 *outPropertyMask)
{
    ESError rv = ES_ERR_OK;

    if (outPropertyMask == NULL || !s_Initialized) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments or state\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    *outPropertyMask = s_Tp->propertyMask;
end:
    return rv;
}

Result
ETicket::GetLastSystemResult()
{
    return esGetLastSystemResult();
}

ES_NAMESPACE_END
