﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2009, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


#include <nn/escore/estypes.h>
#include <nn/iosc/iosc.h>
#include <nn/istorage/istorage.h>

USING_ES_NAMESPACE
USING_ISTORAGE_NAMESPACE

#include <nn/escorei/esi.h>
#include "es_device.h"

ES_NAMESPACE_START



ESError
esGetDeviceCert(void *outDeviceCert, u32 outDeviceCertSize)
{
    ESError rv = ES_ERR_OK;

    if (outDeviceCert == NULL || outDeviceCertSize != ES_DEVICE_CERT_SIZE || sizeof(IOSCEccSignedCert) != ES_DEVICE_CERT_SIZE) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    if ((rv = IOSC_GetDeviceCertificate((IOSCEccSignedCert *) outDeviceCert)) != IOSC_ERROR_OK) {
        esLog(ES_DEBUG_ERROR, "Failed to get device certificate, rv=%d\n", rv);
        rv = ESI_Translate_IOSC_Error(rv);
        goto end;
    }

end:
    return rv;
}

ESError
esSetDeviceCert(const void *inDeviceCert, u32 inDeviceCertSize )
{
    ESError rv = ES_ERR_OK;

    if ( inDeviceCert == NULL || inDeviceCertSize != ES_DEVICE_CERT_SIZE || sizeof( IOSCEccSignedCert ) != ES_DEVICE_CERT_SIZE ) {
        esLog( ES_DEBUG_ERROR, "Invalid arguments\n" );
        rv = ES_ERR_INVALID;
        goto end;
    }

    if ( (rv = IOSC_SetDeviceCertificate( (IOSCEccSignedCert *)inDeviceCert )) != IOSC_ERROR_OK ) {
        esLog( ES_DEBUG_ERROR, "Failed to set device certificate, rv=%d\n", rv );
        rv = ESI_Translate_IOSC_Error( rv );
        goto end;
    }

end:
    return rv;
}

ESError
esSetDevicePrivateKey(const void *inDevicePrivateKey, u32 inDevicePrivateKeySize )
{
    ESError rv = ES_ERR_OK;

    if ( inDevicePrivateKey == NULL || inDevicePrivateKeySize != ES_DEVICE_PRIVATE_KEY_SIZE || sizeof( IOSCEccPrivateKey ) != ES_DEVICE_PRIVATE_KEY_SIZE ) {
        esLog( ES_DEBUG_ERROR, "Invalid arguments\n" );
        rv = ES_ERR_INVALID;
        goto end;
    }

    if ( (rv = IOSC_SetDevicePrivateKey( (IOSCEccPrivateKey *)inDevicePrivateKey )) != IOSC_ERROR_OK ) {
        esLog( ES_DEBUG_ERROR, "Failed to set device private key, rv=%d\n", rv );
        rv = ESI_Translate_IOSC_Error( rv );
        goto end;
    }

end:
    return rv;
}


ESError
esGetDeviceId(ESDeviceId *outDeviceId)
{
    ESError rv = ES_ERR_OK;

    if (outDeviceId == NULL) {
        esLog(ES_DEBUG_ERROR, "Invalid arguments\n");
        rv = ES_ERR_INVALID;
        goto end;
    }

    if ((rv = IOSC_GetData(IOSC_DEV_ID_HANDLE, outDeviceId)) != IOSC_ERROR_OK) {
        esLog(ES_DEBUG_ERROR, "Failed to get device ID, rv=%d\n", rv);
        rv = ESI_Translate_IOSC_Error(rv);
        goto end;
    }

end:
    return rv;
}

ES_NAMESPACE_END
