﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */


#include <nn/ioslibc/ioslibc.h>
#include <nn/csl/aes.h>
#include <nn/csl/aes_api.h>


#define BLOCK_SIZE 128
#define FILE_SIZE 512

#define AES_KEYLEN     128
#define AES_BLOCKLEN   128


/*
  returns >=0 on success, -1 on error
  ***********************************
  use this only for HW
  for software encryption and decryption, the
  key expansion is included
  if key is in ascii isAscii = 1, else 0
  ***********************************

*/
int aes_HwKeyExpand(u8 *key,u8 *expkey)
{
    AesKeyInstance keyI;

    if(aesMakeKey(&keyI, AES_DIR_DECRYPT, AES_KEYLEN, key) != AES_TRUE){
        return -1;
    }

    /* scan for creating expanded key in form used by pi */
    memcpy(expkey, keyI.rk, 44*4);
    return 0;
}

/*************************************
 * Use this only for software (Key expansion included)
 * isAscii = 1 means initVector and key are in ascii
 *************************************
 */
int aes_SwEncrypt(u8 *key,u8 *initVector,u8 *dataIn,u32 bytes,u8 *dataOut)
{
    AesKeyInstance keyI;
    AesCipherInstance cipher;
    int error;

    /* make key */
    if(aesMakeKey(&keyI, AES_DIR_ENCRYPT, AES_KEYLEN, key) != AES_TRUE){
        return -1;
    }

    /* initialise parameters */
    error = aesCipherInit(&cipher, AES_MODE_CBC, initVector);
    if (error != AES_TRUE) {
        /*
        fprintf(stderr,"cipherInit error %d \n", error);
        */
        return -1;
    }

    /*encrypt */
    if(aesBlockEncrypt(&cipher, &keyI, dataIn, bytes*8, dataOut)
       != (int)(bytes*8)){
/*
        fprintf(stderr, "cipher encryption error \n");
*/
        return -1;
    }

    return 0;
}


/*************************************
 * Use this only for software (Key expansion included)
 * isAscii = 1 means key and IV are in ascii
 *************************************
 */

int aes_SwDecrypt(u8 *key,u8 *initVector,u8 *dataIn,u32 bytes,u8 *dataOut)
{
    AesKeyInstance keyI;
    AesCipherInstance cipher;
    int error;

    /* make key */
    if(aesMakeKey(&keyI, AES_DIR_DECRYPT, AES_KEYLEN, key) != AES_TRUE){
        return -1;
    }

    /* initialise parameters */
    error = aesCipherInit(&cipher, AES_MODE_CBC, initVector);
    if (error != AES_TRUE) {
/*
        fprintf(stderr,"cipherInit error %d \n", error);
*/
        return -1;
    }

    /*encrypt */
    if(aesBlockDecrypt(&cipher, &keyI, dataIn, bytes*8, dataOut) != (int)(bytes*8)){
/*
        fprintf(stderr, "cipher encryption error \n");
*/
        return -1;
    }

    return 0;
}
