﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/istorage/istorage.h>

namespace nn { namespace escore {

class MemoryInputStream : public istorage::IInputStream
{
private:
    const u8 *rBuf;
    s64 rSize, rPos;

public:
    MemoryInputStream(const void *buffer, u32 size);
    virtual ~MemoryInputStream();

    virtual Result TryRead(s32 *pOut, void *buffer, u32 size);
    virtual Result TrySetPosition(s64 position);
    virtual Result TryGetPosition(s64 *pOut) const;
    virtual Result TryGetSize(s64 *pOut) const;
};

}}
