﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __SHA1_H__
#define __SHA1_H__

#include <nn/ioslibc/types.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char SHA1_BYTE;
typedef unsigned int SHA1_LONG;

#define SHA1_BLOCKSIZE		64
#define SHA1_DIGESTSIZE		20

typedef unsigned char SHA1Context[112];

extern int SHA1Reset(SHA1Context* ctx);
extern int SHA1Input(SHA1Context* ctx, const SHA1_BYTE *buf, int len);
extern int SHA1Result(SHA1Context* ctx, SHA1_BYTE digest[SHA1_DIGESTSIZE]);

#ifdef __cplusplus
}
#endif

#endif /* __SHA1_H__ */
