﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/NonCreatable.hpp>

//------------------------------------------------------------------------------
namespace lib {
namespace logger {

/// @addtogroup LIB-Logger
//@{
/// ログレベル。下に行くほどレベルが高い。
class LogLevel
    : private ::lib::NonCreatable
{
public:
    enum EnumType
    {
        Debug, ///< デバッグ。ちょっと確認したいときのprintf。
        Trace, ///< トレース。変数・オブジェクトのダンプ、地形判定の結果出力など。
        Info, ///< インフォ。常に表示されるべきもの。セーブタイミングなど。
        Warn, ///< 警告。修正すべき項目。
        Error, ///< エラー。プログラムを不安定にする致命的な項目。

        TERM,
        Min = Debug, ///< 最低のレベル。全出力モード。
        Max = TERM ///< 最高のレベル。一切出力しない。
    };
};
//@}

}} // namespace
// EOF
