﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {

/// 通常の用途のデリータ、削除する方法としてテンプレートなどに利用
template<class TType>
class DefaultDeleter
{
public:
    static void Delete(TType* aPtr)
    {
        // delete対象の型が不完全型だと、デストラクタが呼ばれない問題があるので、
        // その場合にコンパイルエラーになるようにする
        static_assert(0 < sizeof(TType), "Incomplete type.");
        delete aPtr;
    }
};

} // namespace
// EOF
