﻿// 文字コード:UTF-8
/// @file
#include <lib/Color4bPod.hpp>

#include <lib/Color4.hpp>
#include <lib/Color4b.hpp>

//------------------------------------------------------------------------------
namespace lib {

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::Zero()
{
    return Color4b(0, 0, 0, 0);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::One()
{
    return Color4b(0xFF, 0xFF, 0xFF, 0xFF);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::UnitR()
{
    return Color4b(0xFF, 0, 0, 0);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::UnitG()
{
    return Color4b(0, 0xFF, 0, 0);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::UnitB()
{
    return Color4b(0, 0, 0xFF, 0);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::UnitA()
{
    return Color4b(0, 0, 0, 0xFF);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::Black()
{
    return Color4b(0, 0, 0, 0xFF);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::White()
{
    return Color4b(0xFF, 0xFF, 0xFF, 0xFF);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::toRRRR() const
{
    return Color4b(r, r, r, r);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::toGGGG() const
{
    return Color4b(g, g, g, g);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::toBBBB() const
{
    return Color4b(b, b, b, b);
}

//------------------------------------------------------------------------------
const Color4bPod Color4bPod::toAAAA() const
{
    return Color4b(a, a, a, a);
}

//------------------------------------------------------------------------------
const Color4Pod Color4bPod::toRGBAf() const
{
    const float rate = 1.0f / 255.0f;
    return Color4(r * rate, g * rate, b * rate, a * rate);
}

//------------------------------------------------------------------------------
const ::lib::ShortString Color4bPod::toShortString() const
{
    return ::lib::ShortString::FromFormat(
        "%hhu,%hhu,%hhu,%hhu",
        r,
        g,
        b,
        a
        );
}

} // namespace
// EOF
