﻿// 文字コード:UTF-8
/// @file
/// @brief Array.hppの実装を記述する。
/// @author tajima
#include <lib/ArrayUtil.hpp>

#include <lib/debug/Assert.hpp>
#include <lib/Unused.hpp>

//------------------------------------------------------------------------------
namespace lib {

//------------------------------------------------------------------------------
#if defined(LIB_OPT_USE_ASSERT)
void ArrayUtil::RangeCheck(const uint32_t aIndex, const uint32_t aCount)
{
    LIB_UNUSED(aIndex);
    LIB_UNUSED(aCount);
    SYS_ASSERT_LESS(aIndex, aCount);
}

#endif
} // namespace
// EOF
