﻿// 文字コード:UTF-8
/// @file
#pragma once

#include "lib/debug/Assert.hpp"

// 本番でも止まるアサート
//@{
#define SYS_ASSERT_ARRAY_NUM       LIB_ASSERT_ARRAY_NUM
#define SYS_ASSERT                 LIB_ASSERT
#define SYS_ASSERT_MSG             LIB_ASSERT_MSG
#define SYS_ASSERT1                LIB_ASSERT1
#define SYS_ASSERT2                LIB_ASSERT2
#define SYS_ASSERT3                LIB_ASSERT3
#define SYS_ASSERT_POINTER         LIB_ASSERT_POINTER
#define SYS_ASSERT_POINTER_MSG     LIB_ASSERT_POINTER_MSG
#define SYS_ASSERT_NOT_REACHED     LIB_ASSERT_NOT_REACHED
#define SYS_ASSERT_NOT_REACHED_MSG LIB_ASSERT_NOT_REACHED_MSG
#define SYS_ASSERT_EQUAL           LIB_ASSERT_EQUAL
#define SYS_ASSERT_NOT_EQUAL       LIB_ASSERT_NOT_EQUAL
#define SYS_ASSERT_LESS            LIB_ASSERT_LESS
#define SYS_ASSERT_LESS_EQUAL      LIB_ASSERT_LESS_EQUAL
#define SYS_ASSERT_GREATER         LIB_ASSERT_GREATER
#define SYS_ASSERT_GREATER_EQUAL   LIB_ASSERT_GREATER_EQUAL
#define SYS_ASSERT_IN_APPLICATION_THREAD() SYS_ASSERT(::sys::Assert::IsInApplicationThread())
// ocean/sys/ControllerUtil/sysControllerUtil.h
// sys/lyt/ocean/lytShaderUtil.h 向け
#define UF_ASSERT                  LIB_ASSERT
#define UF_PTR_ASSERT              LIB_ASSERT_POINTER
#define UF_ASSERT_MINMAX(aValue, aMin, aMax) LIB_ASSERT(aMin <= aValue && aValue <= aMax)
#define SYS_LOG                    NN_LOG
//@}

// 本番では止まらないアサート
//@{
#if DEBUG_IS_ENABLED
    #define SYS_DEBUG_ASSERT_ARRAY_NUM       LIB_ASSERT_ARRAY_NUM
    #define SYS_DEBUG_ASSERT                 LIB_ASSERT
    #define SYS_DEBUG_ASSERT_MSG             LIB_ASSERT_MSG
    #define SYS_DEBUG_ASSERT1                LIB_ASSERT1
    #define SYS_DEBUG_ASSERT2                LIB_ASSERT2
    #define SYS_DEBUG_ASSERT3                LIB_ASSERT3
    #define SYS_DEBUG_ASSERT_POINTER         LIB_ASSERT_POINTER
    #define SYS_DEBUG_ASSERT_POINTER_MSG     LIB_ASSERT_POINTER_MSG
    #define SYS_DEBUG_ASSERT_NOT_REACHED     LIB_ASSERT_NOT_REACHED
    #define SYS_DEBUG_ASSERT_NOT_REACHED_MSG LIB_ASSERT_NOT_REACHED_MSG
    #define SYS_DEBUG_ASSERT_EQUAL           LIB_ASSERT_EQUAL
    #define SYS_DEBUG_ASSERT_NOT_EQUAL       LIB_ASSERT_NOT_EQUAL
    #define SYS_DEBUG_ASSERT_LESS            LIB_ASSERT_LESS
    #define SYS_DEBUG_ASSERT_LESS_EQUAL      LIB_ASSERT_LESS_EQUAL
    #define SYS_DEBUG_ASSERT_GREATER         LIB_ASSERT_GREATER
    #define SYS_DEBUG_ASSERT_GREATER_EQUAL   LIB_ASSERT_GREATER_EQUAL
    #define SYS_DEBUG_ASSERT_IN_APPLICATION_THREAD() SYS_DEBUG_ASSERT(::sys::Assert::IsInApplicationThread())
#else
    #define SYS_DEBUG_ASSERT_ARRAY_NUM(...)
    #define SYS_DEBUG_ASSERT(...)
    #define SYS_DEBUG_ASSERT_MSG(...)
    #define SYS_DEBUG_ASSERT1(...)
    #define SYS_DEBUG_ASSERT2(...)
    #define SYS_DEBUG_ASSERT3(...)
    #define SYS_DEBUG_ASSERT_POINTER(...)
    #define SYS_DEBUG_ASSERT_POINTER_MSG(...)
    #define SYS_DEBUG_ASSERT_NOT_REACHED(...)
    #define SYS_DEBUG_ASSERT_NOT_REACHED_MSG(...)
    #define SYS_DEBUG_ASSERT_EQUAL(...)
    #define SYS_DEBUG_ASSERT_NOT_EQUAL(...)
    #define SYS_DEBUG_ASSERT_LESS(...)
    #define SYS_DEBUG_ASSERT_LESS_EQUAL(...)
    #define SYS_DEBUG_ASSERT_GREATER(...)
    #define SYS_DEBUG_ASSERT_GREATER_EQUAL(...)
    #define SYS_DEBUG_ASSERT_IN_APPLICATION_THREAD()
#endif
//@}

// EOF
