﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/malloc.h>
#include <sys/uio.h>

int copyin(const void * udaddr, void * kaddr, size_t len)
{
    memcpy(kaddr, udaddr, len);
    return 0;
}

int copyout(const void * kaddr, void * udaddr, size_t len)
{
    memcpy(udaddr, kaddr, len);
    return 0;
}

int copyout_nofault(const void * kaddr, void * udaddr, size_t len)
{
    memcpy(udaddr, kaddr, len);
    return 0;
}

int copyinstr(const void * udaddr, void * kaddr, size_t len, size_t * lencopied)
{
    STUB_WARNING();
    return 0;
}

int uiomove(void *cp, int n, struct uio *uio)
{
    struct iovec *iov;
    int error;
    int cnt;

    while (n > 0 && uio->uio_resid) {
        iov = uio->uio_iov;
        cnt = iov->iov_len;
        if (cnt == 0) {
            uio->uio_iov++;
            uio->uio_iovcnt--;
            continue;
        }
        if (cnt > n) {
            cnt = n;
        }
        switch (uio->uio_segflg) {
        case UIO_USERSPACE:
            if (uio->uio_rw == UIO_READ) {
                error = copyout(cp, iov->iov_base, cnt);
            } else {
                error = copyin(iov->iov_base, cp, cnt);
            }
            if (error) {
                goto out;
            }
            break;
        case UIO_SYSSPACE:
            if (uio->uio_rw == UIO_READ) {
                bcopy(cp, iov->iov_base, cnt);
            } else {
                bcopy(iov->iov_base, cp, cnt);
            }
            break;
        case UIO_NOCOPY:
        default:
            break;
        }
        iov->iov_base = (char*)iov->iov_base + cnt;
        iov->iov_len -= cnt;
        uio->uio_resid -= cnt;
        uio->uio_offset += cnt;
        cp = (char*)cp + cnt;
        n -= cnt;
    }
out:
    return error;
}

int
copyiniov(const struct iovec *iovp, u_int iovcnt, struct iovec **iov, int error)
{
    u_int iovlen;

    *iov = NULL;
    if (iovcnt > UIO_MAXIOV) {
        return (error);
    }
    iovlen = iovcnt * sizeof (struct iovec);
    *iov  = (iovec*)malloc(iovlen, M_IOV, M_WAITOK);
    error = copyin(iovp, *iov, iovlen);
    if (error) {
        free(*iov, M_IOV);
        *iov = NULL;
    }
    return (error);
}


}

