﻿/*-
 * Copyright (c) 2007 Seccuris Inc.
 * All rights reserved.
 *
 * This software was developed by Robert N. M. Watson under contract to
 * Seccuris Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD$");

#include "opt_bpf.h"

#include <sys/param.h>
#include <sys/proc.h>

#include <net/if.h>
#include <net/bpf.h>
#include <net/bpf_zerocopy.h>
#include <net/bpfdesc.h>

/*
 * Zero-copy buffer scheme for BPF: user space "donates" two buffers, which
 * are mapped into the kernel address space using sf_bufs and used directly
 * by BPF.  Memory is wired since page faults cannot be tolerated in the
 * contexts where the buffers are copied to (locks held, interrupt context,
 * etc).  Access to shared memory buffers is synchronized using a header on
 * each buffer, allowing the number of system calls to go to zero as BPF
 * reaches saturation (buffers filled as fast as they can be drained by the
 * user process).  Full details of the protocol for communicating between the
 * user process and BPF may be found in bpf(4).
 */


/*
 * Copy bytes from a source into the specified zbuf.  The caller is
 * responsible for performing bounds checking, etc.
 */
void
bpf_zerocopy_append_bytes(struct bpf_d *d, caddr_t buf, u_int offset,
    void *src, u_int len)
{
    return;
}

/*
 * Copy bytes from an mbuf chain to the specified zbuf: copying will be
 * scatter-gather both from mbufs, which may be fragmented over memory, and
 * to pages, which may not be contiguously mapped in kernel address space.
 * As with bpf_zerocopy_append_bytes(), the caller is responsible for
 * checking that this will not exceed the buffer limit.
 */
void
bpf_zerocopy_append_mbuf(struct bpf_d *d, caddr_t buf, u_int offset,
    void *src, u_int len)
{
    return;
}

/*
 * Notification from the BPF framework that a buffer in the store position is
 * rejecting packets and may be considered full.  We mark the buffer as
 * immutable and assign to userspace so that it is immediately available for
 * the user process to access.
 */
void
bpf_zerocopy_buffull(struct bpf_d *d)
{
    return;
}

/*
 * Notification from the BPF framework that a buffer has moved into the held
 * slot on a descriptor.  Zero-copy BPF will update the shared page to let
 * the user process know and flag the buffer as assigned if it hasn't already
 * been marked assigned due to filling while it was in the store position.
 *
 * Note: identical logic as in bpf_zerocopy_buffull(), except that we operate
 * on bd_hbuf and bd_hlen.
 */
void
bpf_zerocopy_bufheld(struct bpf_d *d)
{
    return;
}

/*
 * Notification from the BPF framework that the free buffer has been been
 * rotated out of the held position to the free position.  This happens when
 * the user acknowledges the held buffer.
 */
void
bpf_zerocopy_buf_reclaimed(struct bpf_d *d)
{
    return;
}

/*
 * Query from the BPF framework regarding whether the buffer currently in the
 * held position can be moved to the free position, which can be indicated by
 * the user process making their generation number equal to the kernel
 * generation number.
 */
int
bpf_zerocopy_canfreebuf(struct bpf_d *d)
{
    return 0;
}

/*
 * Query from the BPF framework as to whether or not the buffer current in
 * the store position can actually be written to.  This may return false if
 * the store buffer is assigned to userspace before the hold buffer is
 * acknowledged.
 */
int
bpf_zerocopy_canwritebuf(struct bpf_d *d)
{
    return 0;
}

/*
 * Free zero copy buffers at request of descriptor.
 */
void
bpf_zerocopy_free(struct bpf_d *d)
{
    return;
}

/*
 * Ioctl to return the maximum buffer size.
 */
int
bpf_zerocopy_ioctl_getzmax(struct thread *td, struct bpf_d *d, size_t *i)
{
    return 0;
}

/*
 * Ioctl to force rotation of the two buffers, if there's any data available.
 * This can be used by user space to implement timeouts when waiting for a
 * buffer to fill.
 */
int
bpf_zerocopy_ioctl_rotzbuf(struct thread *td, struct bpf_d *d,
    struct bpf_zbuf *bz)
{
    return 0;
}

/*
 * Ioctl to configure zero-copy buffers -- may be done only once.
 */
int
bpf_zerocopy_ioctl_setzbuf(struct thread *td, struct bpf_d *d,
    struct bpf_zbuf *bz)
{
    return 0;
}

FORCE_LINK_THIS(_bpf_zerocopy_);
