﻿/*-
 * Copyright (c) 1982, 1986, 1989, 1993
 *    The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
r * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *    @(#)stat.h    8.12 (Berkeley) 6/16/95
 * $FreeBSD$
 */

#ifndef _BSDSYS_STAT_H_
#define _BSDSYS_STAT_H_

#include <sys/cdefs.h>
#include <sys/_timespec.h>
#include <sys/_types.h>

struct stat {
    mode_t      st_mode;            /* inode protection mode */
    uid_t       st_uid;             /* user ID of the file's owner */
    gid_t       st_gid;             /* group ID of the file's group */
    off_t       st_size;            /* file size, in bytes */
    blksize_t   st_blksize;         /* optimal blocksize for I/O */
};

#if defined(NN_BUILD_CONFIG_COMPILER_GCC)
#define    S_IRUSR      0000400     /* R for owner */
#define    S_IWUSR      0000200     /* W for owner */
#define    S_IRGRP      0000040     /* R for group */
#define    S_IWGRP      0000020     /* W for group */
#define    S_IROTH      0000004     /* R for other */
#define    S_IWOTH      0000002     /* W for other */
#endif

#define    S_IFMT       0170000     /* type of file mask */
#define    S_IFSOCK     0140000     /* socket */
#define    S_ISSOCK(m)  (((m) & S_IFMT) == S_IFSOCK)    /* socket */

#endif /* !_BSDSYS_STAT_H_ */
