﻿/*-
 * Copyright (c) 1982, 1985, 1986, 1988, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)socket.h	8.4 (Berkeley) 2/21/94
 * $FreeBSD$
 */

#ifndef _BSD_INTERNAL_SYS_SOCKET_H_
#define	_BSD_INTERNAL_SYS_SOCKET_H_

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/_iovec.h>
#include <machine/_align.h>
#include_next <sys/socket.h>
#include_next <sys/poll.h>
#include_next <sys/select.h>
#include_next <sys/fcntl.h>

#ifdef _KERNEL

#define	MSG_SOCALLBCK   0x10000		/* for use by socket callbacks - soreceive (TCP) */

#define	CMSG_ALIGN(n)	_ALIGN(n)

struct socket;

struct tcpcb *so_sototcpcb(struct socket *so);
struct inpcb *so_sotoinpcb(struct socket *so);
struct sockbuf *so_sockbuf_snd(struct socket *);
struct sockbuf *so_sockbuf_rcv(struct socket *);

int so_state_get(const struct socket *);
void so_state_set(struct socket *, int);

int so_options_get(const struct socket *);
void so_options_set(struct socket *, int);

int so_error_get(const struct socket *);
void so_error_set(struct socket *, int);

int so_linger_get(const struct socket *);
void so_linger_set(struct socket *, int);

struct protosw *so_protosw_get(const struct socket *);
void so_protosw_set(struct socket *, struct protosw *);

void so_sorwakeup_locked(struct socket *so);
void so_sowwakeup_locked(struct socket *so);

void so_sorwakeup(struct socket *so);
void so_sowwakeup(struct socket *so);

void so_lock(struct socket *so);
void so_unlock(struct socket *so);

void so_listeners_apply_all(struct socket *so, void (*func)(struct socket *, void *), void *arg);

#endif

__BEGIN_DECLS

int     socketaccept(int s, struct sockaddr * address, socklen_t * address_length, uint64_t pid);
int     socketbind(int s, const struct sockaddr * address, socklen_t address_length, uint64_t pid);
int     socketconnect(int s, const struct sockaddr * address, socklen_t address_length, uint64_t pid);
int     socketgetpeername(int s, struct sockaddr * address, socklen_t * address_length, uint64_t pid);
int     socketgetsockname(int s, struct sockaddr * address, socklen_t * address_length, uint64_t pid);
int     socketgetsockopt(int s, int level, int option, void * value, socklen_t * length, uint64_t pid);
int     socketlisten(int s, int backlog, uint64_t pid);
ssize_t socketrecv(int s, void * buffer, size_t length, int flags, uint64_t);
ssize_t socketrecvfrom(int s, void * buffer, size_t length, int flags, struct sockaddr * address, socklen_t * address_length, uint64_t pid);
ssize_t socketrecvmsg(int s, struct msghdr * msg, int flags, uint64_t pid);
#ifdef __SigloBSD__
ssize_t socketrecvmmsg(int s, struct mmsghdr* msgvec, size_t vlen, int flags, struct timespec *timeout, uint64_t pid);
ssize_t socketsendmmsg(int s, const struct mmsghdr * msgvec, size_t vlen, int flags, uint64_t pid);
#endif
ssize_t socketsend(int s, const void * buffer, size_t length, int flags, uint64_t pid);
ssize_t socketsendto(int s, const void * buffer, size_t length, int flags, const struct sockaddr * address, socklen_t address_length, uint64_t pid);
ssize_t socketsendmsg(int s, const struct msghdr * msg, int flags, uint64_t pid);
int     socketioctl(int s, uint32_t cmd, void * data, size_t length, uint64_t pid);
int     socketclose(int s, uint64_t);
int     socketsetsockopt(int s, int level, int option, const void * value, socklen_t length, uint64_t pid);
int     socketshutdown(int s, int how, uint64_t pid);
int     socketsockatmark(int s, uint64_t pid);
int     socketsocket(int s, int domain, int type, uint64_t pid);
#ifdef __SigloBSD__
int     socketsocketexempt(int s, int domain, int type, uint64_t pid);
#endif
int     socketwrite(int s, const void * data, size_t length, uint64_t pid);
int     socketread(int s, void * data, size_t length, uint64_t pid);
int     socketopen(const char * name, int flags, uint64_t pid);
int     socketpoll(struct pollfd* descriptors, nfds_t ndescriptors, int timeout, uint64_t pid);
int     socketfcntl(int s, int cmd, int iocmd, uint64_t pid);
int     socketselect(int nsockets, fd_set * read, fd_set * write, fd_set * except, struct timeval * timeout, uint64_t pid);
int     socketsysctl(int* mib, size_t mibcount, void* oldvalue, size_t* oldlength, void* newvalue, size_t newlength, uint64_t pid);
int     socketduplicate(int s, uint64_t socket_owner_pid, uint64_t pid);
void    NetworkInit(void* mempool_start, size_t mempool_size);

__END_DECLS

#endif /* !_SYS_SOCKET_H_ */
