﻿/*-
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <phk@FreeBSD.org> wrote this file.  As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.   Poul-Henning Kamp
 * ----------------------------------------------------------------------------
 *
 * $FreeBSD$
 */

#ifndef _SYS_SMP_H_
#define _SYS_SMP_H_

#ifdef _KERNEL

extern u_int mp_maxid;
extern int   mp_maxcpus;
extern int   mp_ncpus;
extern u_int mp_activecpus;
extern volatile int smp_started;

#define	CPU_ABSENT(x_cpu)	(!(mp_activecpus & (1<<(x_cpu))))

/*
 * Macros to iterate over non-absent CPUs.  CPU_FOREACH() takes an
 * integer iterator and iterates over the available set of CPUs.
 * CPU_FIRST() returns the id of the first non-absent CPU.  CPU_NEXT()
 * returns the id of the next non-absent CPU.  It will wrap back to
 * CPU_FIRST() once the end of the list is reached.  The iterators are
 * currently implemented via inline functions.
 */
#define	CPU_FOREACH(i)							\
    for ((i) = 0; (i) <= mp_maxid; (i)++)				\
        if (!CPU_ABSENT((i)))

#endif /* _KERNEL */

#endif /* _SYS_SMP_H_ */
