﻿/*-
 * Copyright (c) 2001 Wind River Systems, Inc.
 * All rights reserved.
 * Written by: John Baldwin <jhb@FreeBSD.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef _SYS_PCPU_H_
#define	_SYS_PCPU_H_

__BEGIN_DECLS

#include <sys/queue.h>

struct thread*      get_current_thread();
struct proc*        get_current_proc();


int                 get_current_cpu();
#define curthread   get_current_thread()
#define curproc     get_current_proc()

#ifdef SMP
#define curcpu      get_current_cpu()
#else
#define curcpu      (0)
#endif

struct pcpu {
    STAILQ_ENTRY(pcpu) pc_allcpu;
    void               *pc_netisr;            /* netisr SWI cookie */
    u_int              pc_cpuid;              /* this CPU id */
    uintptr_t          data;
};

STAILQ_HEAD(cpuhead, pcpu);
extern struct cpuhead cpuhead;
extern struct pcpu pcpus[];
#define pcpu_find(i)            &(pcpus[(i)])

/* Accessor to elements allocated via UMA_ZONE_PCPU zone. */
static inline void *
zpcpu_get(void *base)
{
    return ((char *)(base) + sizeof(struct pcpu) * curcpu);
}

static inline void *
zpcpu_get_cpu(void *base, int cpu)
{
    return ((char *)(base) + sizeof(struct pcpu) * cpu);
}

__END_DECLS

#endif /* !_SYS_PCPU_H_ */
