﻿/*-
 * Copyright (c) 1992, 1993
 *    The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *    @(#)libkern.h    8.1 (Berkeley) 6/10/93
 * $FreeBSD$
 */

#ifndef _SYS_LIBKERN_H_
#define _SYS_LIBKERN_H_

#ifdef _KERNEL

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/systm.h>
#include <string.h>

/* BCD conversions. */
extern u_char const    bcd2bin_data[];
extern u_char const    bin2bcd_data[];
extern char   const    hex2ascii_data[];

#define bcd2bin(bcd)   (bcd2bin_data[bcd])
#define bin2bcd(bin)   (bin2bcd_data[bin])
#define hex2ascii(hex) (hex2ascii_data[hex])

static __inline int imax(int a, int b) { return (a > b ? a : b); }
static __inline int imin(int a, int b) { return (a < b ? a : b); }
static __inline long lmax(long a, long b) { return (a > b ? a : b); }
static __inline long lmin(long a, long b) { return (a < b ? a : b); }
static __inline u_int max(u_int a, u_int b) { return (a > b ? a : b); }
static __inline u_int min(u_int a, u_int b) { return (a < b ? a : b); }
static __inline quad_t qmax(quad_t a, quad_t b) { return (a > b ? a : b); }
static __inline quad_t qmin(quad_t a, quad_t b) { return (a < b ? a : b); }
static __inline u_long ulmax(u_long a, u_long b) { return (a > b ? a : b); }
static __inline u_long ulmin(u_long a, u_long b) { return (a < b ? a : b); }
static __inline off_t omax(off_t a, off_t b) { return (a > b ? a : b); }
static __inline off_t omin(off_t a, off_t b) { return (a < b ? a : b); }

static __inline quad_t qabs(quad_t a) { return (a < 0 ? -a : a); }

#define    ARC4_ENTR_NONE    0    /* Don't have entropy yet. */
#define    ARC4_ENTR_HAVE    1    /* Have entropy. */
#define    ARC4_ENTR_SEED    2    /* Reseeding. */
extern int arc4rand_iniseed_state;

/* Prototypes for non-quad routines. */
uint32_t arc4random(void);
void arc4rand(void *ptr, u_int len, int reseed);

int  bcmp(const void *, const void *, size_t);
void *bsearch(const void *, const void *, size_t, size_t, int (*)(const void *, const void *));

int ffs(int);
int ffsl(long);
int fls(int);
int flsl(long);
int flsll(long long);

u_long random(void);

extern const uint32_t crc32_tab[];

static __inline uint32_t crc32_raw(const void *buf, size_t size, uint32_t crc)
{
    const uint8_t *p = (const uint8_t *)buf;

    while (size--)
        crc = crc32_tab[(crc ^ *p++) & 0xFF] ^ (crc >> 8);
    return (crc);
}

static __inline uint32_t crc32(const void *buf, size_t size)
{
    uint32_t crc;

    crc = crc32_raw(buf, size, ~0U);
    return (crc ^ ~0U);
}

uint32_t calculate_crc32c(uint32_t crc32c, const unsigned char *buffer, unsigned int length);

extern const char hex2ascii_data[];
#define hex2ascii(hex)  (hex2ascii_data[hex])

#endif /* _KERNEL */

#endif /* !_SYS_LIBKERN_H_ */
