﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#ifndef _SYS_CALLOUT_H_
#define _SYS_CALLOUT_H_

#include <sys/systm.h>
#include <sys/_callout.h>
#include <sys/mutex.h>
#include <sys/rwlock.h>

#define CALLOUT_LOCAL_ALLOC      0x0001 /* was allocated from callfree */
#define CALLOUT_ACTIVE           0x0002 /* callout is currently active */
#define CALLOUT_PENDING          0x0004 /* callout is waiting for timeout */
#define CALLOUT_MPSAFE           0x0008 /* callout handler is mp safe */
#define CALLOUT_RETURNUNLOCKED   0x0010 /* handler returns with mtx unlocked */
#define CALLOUT_SHAREDLOCK       0x0020 /* callout lock held in shared mode */
#define CALLOUT_DFRMIGRATION     0x0040 /* callout in deferred migration mode */
#define CALLOUT_PROCESSED        0x0080 /* callout in wheel or processing list? */
#define CALLOUT_DIRECT           0x0100 /* allow exec from hw int context */

#define C_DIRECT_EXEC            0x0001 /* direct execution of callout */
#define C_PRELBITS               7
#define C_PRELRANGE              ((1 << C_PRELBITS) - 1)
#define C_PREL(x)                (((x) + 1) << 1)
#define C_PRELGET(x)             (int)((((x) >> 1) & C_PRELRANGE) - 1)
#define C_HARDCLOCK               0x0100 /* align to hardclock() calls */
#define C_ABSOLUTE                0x0200 /* event time is absolute. */

struct callout_handle {
    struct callout *callout;
};

#ifdef _KERNEL
void callout_init(struct callout *c, int mpsafe);
void callout_init_mtx(struct callout *c, struct mtx *mtx, int flags);
int callout_stop(struct callout *c);
int callout_drain(struct callout *c);
int callout_pending(struct callout *c);
int callout_active(struct callout *c);
void callout_deactivate(struct callout *c);
int callout_reset_sbt_on(struct callout *c, sbintime_t sbt, sbintime_t pr, void (*c_func)(void *), void *arg, int cpu, int flags);
int callout_schedule(struct callout *a, int b);
void callout_init_rw(struct callout *c, struct rwlock *rw, int flags);
#define callout_reset_on(c, to, fn, arg, cpu) \
    callout_reset_sbt_on((c), tick_sbt * (to), 0, (fn), (arg), (cpu), 0)
#define callout_reset(c, on_tick, fn, arg)                              \
    callout_reset_on((c), (on_tick), (fn), (arg), (c)->c_cpu)
#endif

#endif /* _SYS_CALLOUT_H_ */
