﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/nn_StaticAssert.h>
#include <nn/socket/private/thread.h>
#include <sys/proc.h>

__BEGIN_DECLS

#define BSD_THREAD_MAGIC    0xd6892014

/* we need to link siglo and bsd style thread structures,
 * for faster lookup, store both in a structure and use
 * reverse offset to find pointer to parent structure
 * containing both the siglo style ThreadType and bsd struct thread/ucred
 */
typedef struct {
    nn::os::ThreadType siglo_thread;  /* actual siglo's ThreadType              */
    struct thread      bsd_thread;    /* bsd's stuct thread keeping credentials */
    unsigned int       magic;         /* to catch non-initialized siglo threads inside bsd code */
} NetworkThreadInternal;

/* make sure external definition has enough space for bsd meta data */
NN_STATIC_ASSERT(sizeof(NetworkThreadInternal) <= sizeof(NetworkThread));

/* return pointer to parent based on nn::os::ThreadType pointer */
#define BSD_THREAD_FROM_SIGLO(ptd)                                                                 \
({                                                                                                 \
    NetworkThreadInternal* td = (NetworkThreadInternal*)(ptd);                                                     \
    NN_ABORT_UNLESS(td->magic == BSD_THREAD_MAGIC);                                                \
    &td->bsd_thread;                                                                               \
})

__END_DECLS

