﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#ifndef __FDALLOC_H__
#define __FDALLOC_H__

#include <sys/filedesc.h>

static const int BITS_PER_WORD = sizeof(NDSLOTTYPE) * CHAR_BIT;

static inline int get_field(NDSLOTTYPE* data, uint32_t offset)
{
    uint32_t word = offset / BITS_PER_WORD;
    uint32_t bit  = offset % BITS_PER_WORD;
    return (data[word] & (1<<bit));
}

static inline void set_field(NDSLOTTYPE* data, uint32_t offset)
{
    uint32_t word = offset / BITS_PER_WORD;
    uint32_t bit  = offset % BITS_PER_WORD;
    data[word] |= (0x1 << bit);
    return;
}

static inline void clr_field(NDSLOTTYPE* data, uint32_t offset)
{
    uint32_t word = offset / BITS_PER_WORD;
    uint32_t bit  = offset % BITS_PER_WORD;
    data[word] &= ~(0x1 << bit);
    return;
}

int  idalloc(struct filedesc* fdp);
void idfree(struct filedesc* fdp, int fd);

#endif
