﻿/*
 * Fundamental constants relating to ethernet.
 *
 * $FreeBSD$
 *
 */

#include_next <net/ethernet.h>

#ifndef _NET_ETHERNET_H_
#define _NET_ETHERNET_H_

/*
 * Ethernet-specific mbuf flags.
 */
#define M_HASFCS M_PROTO5

#ifdef _KERNEL

struct ifnet;
struct mbuf;
struct route;
struct sockaddr;
struct bpf_if;

extern	uint32_t ether_crc32_le(const uint8_t *, size_t);
extern	uint32_t ether_crc32_be(const uint8_t *, size_t);
extern	void ether_demux(struct ifnet *, struct mbuf *);
extern	void ether_ifattach(struct ifnet *, const u_int8_t *);
extern	void ether_ifdetach(struct ifnet *);
extern	int  ether_ioctl(struct ifnet *, u_long, caddr_t);
extern	int  ether_output(struct ifnet *, struct mbuf *,
        const struct sockaddr *, struct route *);
extern	int  ether_output_frame(struct ifnet *, struct mbuf *);
extern	char *ether_sprintf(const u_int8_t *);
void	ether_vlan_mtap(struct bpf_if *, struct mbuf *,
        void *, u_int);
struct mbuf  *ether_vlanencap(struct mbuf *, uint16_t);

#else /* _KERNEL */

#include <sys/cdefs.h>

/*
 * Ethernet address conversion/parsing routines.
 */
__BEGIN_DECLS
struct	ether_addr *ether_aton(const char *);
struct	ether_addr *ether_aton_r(const char *, struct ether_addr *);
int	ether_hostton(const char *, struct ether_addr *);
int	ether_line(const char *, struct ether_addr *, char *);
char 	*ether_ntoa(const struct ether_addr *);
char 	*ether_ntoa_r(const struct ether_addr *, char *);
int	ether_ntohost(char *, const struct ether_addr *);
__END_DECLS

#endif /* !_KERNEL */

#endif /* !_NET_ETHERNET_H_ */
