﻿/*-
 * Copyright (c) 1990, 1991, 1993
 *    The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from the Stanford/CMU enet packet filter,
 * (net/enet.c) distributed as part of 4.3BSD, and code contributed
 * to Berkeley by Steven McCanne and Van Jacobson both of Lawrence
 * Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)bpf.h    8.1 (Berkeley) 6/10/93
 *    @(#)bpf.h    1.34 (LBL)     6/16/96
 *
 * $FreeBSD$
 */

#ifndef _NET_BPF_H_
#define _NET_BPF_H_

#ifdef _KERNEL

#include_next <net/bpf.h>

#define MTAG_BPF        0x627066
#define MTAG_BPF_TIMESTAMP    0

#ifdef MALLOC_DECLARE
MALLOC_DECLARE(M_BPF);
#endif

#ifdef SYSCTL_DECL
SYSCTL_DECL(_net_bpf);
#endif

/*
 * Rotate the packet buffers in descriptor d.  Move the store buffer into the
 * hold slot, and the free buffer ino the store slot.  Zero the length of the
 * new store buffer.  Descriptor lock should be held. Hold buffer must
 * not be marked "in use".
 */
#define ROTATE_BUFFERS(d)    do {                   \
    (d)->bd_hbuf = (d)->bd_sbuf;                    \
    (d)->bd_hlen = (d)->bd_slen;                    \
    (d)->bd_sbuf = (d)->bd_fbuf;                    \
    (d)->bd_slen = 0;                               \
    (d)->bd_fbuf = NULL;                            \
    bpf_bufheld(d);                                 \
} while (0)

/*
 * Descriptor associated with each attached hardware interface.
 * FIXME: this structure is exposed to external callers to speed up
 * bpf_peers_present() call. However we cover all fields not needed by
 * this function via BPF_INTERNAL define
 */
struct bpf_if {
    LIST_ENTRY(bpf_if) bif_next;        /* list of all interfaces */
    LIST_HEAD(, bpf_d) bif_dlist;       /* descriptor list */
#ifdef BPF_INTERNAL
    u_int bif_dlt;                      /* link layer type */
    u_int bif_hdrlen;                   /* length of link header */
    struct ifnet *bif_ifp;              /* corresponding interface */
    struct rwlock bif_lock;             /* interface lock */
    LIST_HEAD(, bpf_d)    bif_wlist;    /* writer-only list */
    int flags;                          /* Interface flags */
#endif
};

void  bpf_bufheld(struct bpf_d *d);
int   bpf_validate(const struct bpf_insn *, int);
void  bpf_tap(struct bpf_if *, u_char *, u_int);
void  bpf_mtap(struct bpf_if *, struct mbuf *);
void  bpf_mtap2(struct bpf_if *, void *, u_int, struct mbuf *);
void  bpfattach(struct ifnet *, u_int, u_int);
void  bpfattach2(struct ifnet *, u_int, u_int, struct bpf_if **);
void  bpfdetach(struct ifnet *);

void  bpfilterattach(int);
u_int bpf_filter(const struct bpf_insn *, u_char *, u_int, u_int);

static __inline int
bpf_peers_present(struct bpf_if *bpf)
{

    if (!LIST_EMPTY(&bpf->bif_dlist))
        return (1);
    return (0);
}

#define BPF_TAP(_ifp,_pkt,_pktlen) do {                 \
    if (bpf_peers_present((_ifp)->if_bpf))              \
        bpf_tap((_ifp)->if_bpf, (_pkt), (_pktlen));     \
} while (0)
#define BPF_MTAP(_ifp,_m) do {                          \
    if (bpf_peers_present((_ifp)->if_bpf)) {            \
        M_ASSERTVALID(_m);                              \
        bpf_mtap((_ifp)->if_bpf, (_m));                 \
    }                                                   \
} while (0)
#define BPF_MTAP2(_ifp,_data,_dlen,_m) do {             \
    if (bpf_peers_present((_ifp)->if_bpf)) {            \
        M_ASSERTVALID(_m);                              \
        bpf_mtap2((_ifp)->if_bpf,(_data),(_dlen),(_m)); \
    }                                                   \
} while (0)
#endif

/*
 * Number of scratch memory words (for BPF_LD|BPF_MEM and BPF_ST).
 */
#define BPF_MEMWORDS 16

#endif /* _NET_BPF_H_ */
