﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include "ntd-test-tls.h"

extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

class Hoge5
{
public:
    int x;
    nn::os::ThreadType *Hoge5_thread;
    char *name = (char *)"<unitialized name>";
    Hoge5() {
        Hoge5_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge5 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge5_thread);
    }
    Hoge5(char *func_name, int T) {
        x = T;
        name = func_name;
        Hoge5_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge5 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge5_thread);
    }
    ~Hoge5() { TESTLOG("Good-bye from class Hoge5 (%s) %d thread address 0x%08zX!", name, x, (size_t)Hoge5_thread); }
};
thread_local Hoge5 g_Hoge5((char *)"g_Hoge5_0", 47);

#if ENABLE_TLS_INT
thread_local int tls_int;
#define AN_INT tls_int
#define AN_INT_NAME "tls_int"
#else
static int static_int;
#define AN_INT static_int
#define AN_INT_NAME "static_int"
#endif

extern void tls_horizon_2nd_file(void);
void tls_horizon_2nd_file()
{
    TESTLOG("tls_horizon_2nd_file: cur_thread = 0x%08zX", (size_t)nn::os::GetCurrentThread());
    long num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the beginning of tls_horizon_2nd_file.", num_dtrs_to_call);

    AN_INT = 7;
    TESTLOG("tls_horizon_2nd_file entered with %s = %d", (char *)AN_INT_NAME, AN_INT);
    TESTLOG("tls_horizon_2nd_file exited with %s = %d", (char *)AN_INT_NAME, ++AN_INT);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the end of tls_horizon_2nd_file.", num_dtrs_to_call);
}

