﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include "ntd-test-tls.h"

extern void *CallNro(void);
extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_NRO_NAME)
#if ULONG_MAX == 0xffffffff
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif

#define MIN_ALIGN nn::os::ThreadStackAlignment

#define STACK_SIZE (3 * MIN_ALIGN)

static const size_t            ThreadStackSize = STACK_SIZE;                 // スレッド操作スレッドのスタックサイズ
static NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack1[ ThreadStackSize ];   // 1つ目のスレッドのスタック
static nn::os::ThreadType      g_Thread1;

static int num_Hoge5DestructorCalls = 0;
class Hoge5
{
public:
    int x;
    nn::os::ThreadType *Hoge5_thread;
    void *this_obj;
    char *name = (char *)"<unitialized name>";
    long hoge5_num_dtrs_to_call = 0;
    Hoge5() {
        Hoge5_thread = nn::os::GetCurrentThread();
        this_obj = (void*)this;
        TESTLOG("Hello from class Hoge5 (%s) %d thread address 0x%08zX; this = 0x%08zX", name, x, (size_t)Hoge5_thread, (size_t)this_obj);
    }
    Hoge5(char *func_name, int T) {
        name = func_name;
        x = T;
        Hoge5_thread = nn::os::GetCurrentThread();
        this_obj = (void*)this;
        TESTLOG("Hello from class Hoge5 (%s) %d thread address 0x%08zX; this = 0x%08zX", name, x, (size_t)Hoge5_thread, (size_t)this_obj);
    }
    ~Hoge5() {
        TESTLOG("Good-bye from class Hoge5 (%s) %d thread address 0x%08zX; this = 0x%08zX!", name, x, (size_t)Hoge5_thread, (size_t)this_obj);
        hoge5_num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
        TESTLOG("in ~Hoge5(): got %ld uncalled destructors in the NRO", hoge5_num_dtrs_to_call);
        TESTCASE_MESSAGE(hoge5_num_dtrs_to_call == 1, "Before exiting ~Hoge5() we expected 1 uncalled Destructor but we got %ld.", hoge5_num_dtrs_to_call);
        num_Hoge5DestructorCalls++;
    }
};

static void test_nro_tls_constructors(void *arg)
{
    TESTLOG("test_nro_tls_constructors entered 1");
    NN_UNUSED(arg);
    long            num_dtrs_to_call = 0;

    TESTLOG("test_nro_tls_constructors calling __nnmusl_get_tls_dtors_status() for module with __dso_handle = 0x%08zX", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before entering test_nro_tls_constructors we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);

    thread_local Hoge5 g_Hoge5((char *)"g_Hoge5_0", 47);

    TESTLOG("test_nro_tls_constructors calling __nnmusl_get_tls_dtors_status() for NRO with __dso_handle = 0x%08zX", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 1, "Before exiting nnMain we expected 1 uncalled Destructor but we got %ld.", num_dtrs_to_call);
}

void *CallNro()
{
    TESTLOG("Start %s", TEST_NAME);

    nn::Result      result;
    long            num_dtrs_to_call = 0;
    int atexit_result;
    nn::os::ThreadType *main_thread = nn::os::GetCurrentThread();
    TESTLOG("1: main_thread = 0x%08zX", (size_t)main_thread);

    result = nn::os::CreateThread( &g_Thread1, test_nro_tls_constructors, NULL, g_ThreadStack1, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread1." );

    TESTLOG("g_Thread1 = 0x%08zX", (size_t)&g_Thread1);

    TESTLOG("2: main_thread = 0x%08zX", (size_t)main_thread);

    // スレッドの実行を開始する
    nn::os::StartThread( &g_Thread1 );
    TESTLOG("g_Thread1 started");

    // スレッドが終了するのを待つ
    nn::os::WaitThread( &g_Thread1 );
    TESTLOG("g_Thread1 did wait");

    // スレッドを破棄する
    nn::os::DestroyThread( &g_Thread1 );
    TESTLOG("g_Thread1 destroyed");

    TESTLOG("num_Hoge5DestructorCalls = %d", num_Hoge5DestructorCalls);
    TESTCASE_MESSAGE(num_Hoge5DestructorCalls == 1, "Before exiting CallNro we expected 1 call to ~Hoge5() but we got %ld.",
        num_Hoge5DestructorCalls);

    TESTLOG("CallNro calling __nnmusl_get_tls_dtors_status() for module with __dso_handle = 0x%08zX", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before exiting CallNro we expected 0 uncalled Destructors but we got %ld.", num_dtrs_to_call);
    TESTLOG("End %s", TEST_NAME);
    return __dso_handle;
}


