﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include <inttypes.h>
#include "ntd-test-tls.h"

extern "C" void CallNro(void);

#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_NRO_NAME)
#if ULONG_MAX == 0xffffffff
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif

thread_local int nro_var1 = 21;
thread_local double nro_var2 = 22.0;
__attribute__((aligned(TLS_ALIGNMENT))) thread_local double nro_var3 = 23.0;
thread_local short nro_var4 = 24;
thread_local char *nro_var5 = (char *)"Twenty-Five";
thread_local char nro_string[20] = {'T','w','e','n','t','y','-','S','i','x', 0};
thread_local char *nro_var6 = (char *)nro_string;

extern "C" void CallNro()
{
    TESTLOG("Start %s", TEST_NAME);

    nro_var1++;
    nro_var2++;
    nro_var3++;
    nro_var4++;
    nro_var5[0] = 'f';
    nro_var6[0] = 'S';

    TESTLOG("End %s", TEST_NAME);
}


