/*-----------------------------------------------------------------------*
  Project: csGrass
  File: sky.vs

  Copyright (C)2013 Nintendo  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo and/or its licensed developers
  and are protected by national and international copyright laws. They
  may not be disclosed to third parties or copied or duplicated in any
  form, in whole or in part, without the prior written consent of
  Nintendo.

  The content herein is highly confidential and should be handled
  accordingly.
*-----------------------------------------------------------------------*/

struct VertexShaderInput
{
    float4 position : a_position;
};

struct VertexShaderOutput
{
    float4 position : SV_POSITION;
    float4 viewDir : viewDir;
};

cbuffer u_VUniforms : register( b0 )
{
    matrix InvProjMatrix;
    matrix InvModelviewMatrix;
};

VertexShaderOutput main( VertexShaderInput input )
{
    VertexShaderOutput output;

    float4 prj = mul( InvProjMatrix, input.position );
    float4 dir = mul( InvModelviewMatrix, float4( prj.xyz, 0.0 ) );
    output.viewDir = dir;

    output.position = input.position;

    return output;
}
