﻿/* $Id$ */

/* wcsncmp( const wchar_t *, const wchar_t *, size_t )

   This file is part of the Public Dotest_wcsncmp C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <wchar.h>


#include "pdclib-tests/pdclib-tests.h"

int test_wcsncmp( void )
{
    wchar_t cmpabcde[] = L"abcde\0f";
    wchar_t cmpabcd_[] = L"abcde\xfc";
    wchar_t empty[] = L"";
    wchar_t x[] = L"x";
    TESTCASE( wcsncmp( wabcde, cmpabcde, 5 ) == 0 );
    TESTCASE( wcsncmp( wabcde, cmpabcde, 10 ) == 0 );
    TESTCASE( wcsncmp( wabcde, wabcdx, 5 ) < 0 );
    TESTCASE( wcsncmp( wabcdx, wabcde, 5 ) > 0 );
    TESTCASE( wcsncmp( empty, wabcde, 5 ) < 0 );
    TESTCASE( wcsncmp( wabcde, empty, 5 ) > 0 );
    TESTCASE( wcsncmp( wabcde, wabcdx, 4 ) == 0 );
    TESTCASE( wcsncmp( wabcde, x, 0 ) == 0 );
    TESTCASE( wcsncmp( wabcde, x, 1 ) < 0 );
    TESTCASE( wcsncmp( wabcde, cmpabcd_, 10 ) < 0 );
    return TEST_RESULTS;
}
