﻿/* $Id$ */

/* lldiv( long long int, long long int )

   This file is part of the Public Dotest_lldiv C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdlib.h>


#include "pdclib-tests/pdclib-tests.h"

int test_lldiv( void )
{
    lldiv_t result;
    result = lldiv( 5ll, 2ll );
    TESTCASE( result.quot == 2 && result.rem == 1 );
    result = lldiv( -5ll, 2ll );
    TESTCASE( result.quot == -2 && result.rem == -1 );
    result = lldiv( 5ll, -2ll );
    TESTCASE( result.quot == -2 && result.rem == 1 );
    TESTCASE( sizeof( result.quot ) == sizeof( long long ) );
    TESTCASE( sizeof( result.rem )  == sizeof( long long ) );
    return TEST_RESULTS;
}

