﻿/* $Id$ */

/* perror( const char * )

   This file is part of the Public Dotest_perror C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>


#include "pdclib-tests/pdclib-tests.h"
#include <stdlib.h>
#include <string.h>
#include <limits.h>

int test_perror( void )
{
    FILE * fh;
    unsigned long long max = ULLONG_MAX;
    char buffer[100];
    sprintf( buffer, "%llu", max );
    TESTCASE( ( fh = freopen( testfile, "wb+", stderr ) ) != NULL );
    TESTCASE( strtol( buffer, NULL, 10 ) == LONG_MAX );
    perror( "Test" );
    rewind( fh );
    TESTCASE( fread( buffer, 1, 7, fh ) == 7 );
    TESTCASE( memcmp( buffer, "Test: ", 6 ) == 0 );
    TESTCASE( fclose( fh ) == 0 );
    TESTCASE( remove( testfile ) == 0 );
    return TEST_RESULTS;
}

