﻿/* $Id$ */

/* _PDCLIB_fvopen( _PDCLIB_fd_t fd, _PDCLIB_fileops_t *  )

   This file is part of the Public Dotest__PDCLIB_fvopen C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>
#include <stdlib.h>

#include "pdclib-tests/pdclib-tests.h"

int test__PDCLIB_fvopen( void )
{
    /* Some of the tests are not executed for regression tests, as the libc on
       my system is at once less forgiving (segfaults on mode NULL) and more
       forgiving (accepts undefined modes).
    */
    FILE * fh;
    remove( testfile );
    TESTCASE_NOREG( fopen( NULL, NULL ) == NULL );
    TESTCASE_NOREG( fopen( NULL, "w" ) == NULL );
    TESTCASE_NOREG( fopen( "", NULL ) == NULL );
    TESTCASE_NOREG( fopen( "", "w" ) == NULL );
    TESTCASE_NOREG( fopen( "foo", "" ) == NULL );
    TESTCASE_NOREG( fopen( testfile, "wq" ) == NULL ); /* Undefined mode */
    TESTCASE_NOREG( fopen( testfile, "wr" ) == NULL ); /* Undefined mode */
    TESTCASE_NOREG( ( fh = fopen( testfile, "w" ) ) != NULL );
    TESTCASE_NOREG( fclose( fh ) == 0 );
    TESTCASE_NOREG( remove( testfile ) == 0 );
    return TEST_RESULTS;
}

