﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h" /* Needs to be included before 'time.h' for '_GNU_SOURCE' */
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <semaphore.h>
#include <time.h>

#include "ntd-tests/ntd-tests.h"

void test_sem_timedwait()
{
    struct timespec tm;
    sem_t sem;
    int i=0;
    int rc;

    NTD_TEST_GROUP_START("sem_timedwait", 3);

    rc = sem_init( &sem, 0, 0);
    TESTCASE_MESSAGE(rc == 0, "sem_init( &sem, 0, 0) returned %d expected 0", &sem, rc);

    do {
        addmillisecondsfromnow(&tm, 10);
        i++;
        TESTWARN("i=%d\n",i);
        if (i==10) {
            rc = sem_post(&sem);
            TESTCASE_MESSAGE(rc == 0, "sem_post(&sem) returned %d expected 0", &sem, rc);
        }

    } while ( sem_timedwait( &sem, &tm ) == -1 );

    TESTWARN("Semaphore acquired after %d timeouts\n", i);

    rc = sem_destroy(&sem);
    TESTCASE_MESSAGE(rc == 0, "sem_destroy(%p) returned %d expected 0", &sem, rc);

    NTD_TEST_GROUP_END("sem_timedwait", 3);
}
