﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
     #include <string.h>
     #include <unistd.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

pthread_mutex_t setthread_mutex = PTHREAD_MUTEX_INITIALIZER;

static void *threadfunc(void *parm)
{
    TESTWARN("In the thread.\n");
    pthread_mutex_lock(&setthread_mutex);

    return NULL;
}

void test_pthread_setname_np()
{
    pthread_t             thread;
    int                   rc=0;
    char                  theName[32];
    const char *testcase = __FUNCTION__;

    NTD_TEST_GROUP_START("setname_np", 3);

    memset(theName, 0x00, sizeof(theName));
    // lock so thread stays while we change it's name
    pthread_mutex_lock(&setthread_mutex);
    TESTWARN("Create thread using the default attributes\n");
    rc = pthread_create(&thread, NULL, threadfunc, NULL);
    TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);
    if(0 == rc)
    {
        /* linux limits thread name to 16 bytes including NULL */
        rc = pthread_setname_np(thread, "123456789012345");
        TESTCASE_MESSAGE(rc == 0, "pthread_setname_np(%p, \"1234567890123345\" failed %d\n", thread, rc);
        if(0 == rc)
        {
            rc = pthread_getname_np(thread, theName, 11);
            TESTCASE_MESSAGE(rc == ERANGE, "pthread_getname_np(%p, %p, 11) expected ERANGE(%d) but got %d",
                thread, theName, ERANGE, rc);
            rc = pthread_getname_np(thread, theName, 31);
            TESTCASE_MESSAGE(rc == 0, "pthread_getname_np(%p, %p, 31) expected 0 but got %d",
                thread, theName, rc);
        }
        pthread_mutex_unlock(&setthread_mutex);
        rc = pthread_join(thread, NULL);
        TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);
    }
    NTD_TEST_GROUP_END("setname_np", 3);
}
