﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

static uintptr_t  okStatus        = 34;

static void *threadfunc(void *parm)
{
  TESTWARN("Inside secondary thread\n");
  return (void *)(okStatus);
}

void test_pthread_join()
{
  pthread_t             thread;
  int                   rc=0;
  void                 *status;
  bool                  test;

  NTD_TEST_GROUP_START("join", 3);

  TESTWARN("Create thread using attributes that allow join\n");
  rc = pthread_create(&thread, NULL, threadfunc, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);

  TESTWARN("Wait for the thread to exit\n");
  rc = pthread_join(thread, &status);
  TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);


  test = ( (uintptr_t)(status) == okStatus );
  TESTCASE( test );
  if (!test) {
    TESTWARN("Secondary thread failed\n");
  }

  NTD_TEST_GROUP_END("join", 3);
}

#if 0
Debug Output:

Enter Testcase - QP0WTEST/TPJOIN0
Create thread using attributes that allow join
Wait for the thread to exit
Inside secondary thread
Got secondary thread status as expected
Main completed
#endif
