﻿#include "ntd-tests/ntd-tests.h"
#define _XOPEN_SOURCE 700
#include <stdio.h>
#include <stdlib.h>

/* naive statistical checks */

/* error p ~ 1.6e-6 */
static int chkmissing(long *x)
{
    int d[8] = {0};
    int i;
    for (i = 0; i < 100; i++)
        d[x[i]%8]++;
    for (i = 0; i < 8; i++)
        if (d[i]==0)
            return 1;
    return 0;
}

/* error p ~ 4e-6 */
static int chkrepeat(long *x)
{
    int i, j;
    for (i = 0; i < 100; i++)
        for (j = 0; j < i; j++)
            if (x[i] == x[j])
                return 1;
    return 0;
}

/* error p ~ 1e-6 */
static unsigned orx;
static int chkones(long *x)
{
    int i;
    orx = 0;
    for (i = 0; i < 20; i++)
        orx |= x[i];
    return orx != 0x7fffffff;
}

void checkseed(unsigned seed, long *x)
{
    int i;
    struct random_data data;
    char state[128];
    uint32_t random_value;

    int result = initstate_r(state, sizeof(state), &data);
    TESTCASE_MESSAGE(result == 0, "initstate_r(%p, %d, %p) returned %d expected 0",
        state, sizeof(state), &data, result);

    result = srandom_r(seed, &data);
    TESTCASE_MESSAGE(result == 0, "srandom_r(%d, %p) returned %d expected 0", seed, &data, result);

    for (i = 0; i < 100; i++) {
        result = random_r(&data, &random_value);
        TESTCASE_MESSAGE(result == 0, "random_r(%p, %p) returned %d expected 0", &data, &random_value, result);
        x[i] = random_value;
    }
    if (chkmissing(x))
        t_error("weak seed %d, missing pattern in low bits\n", seed);
    else
        TESTCASE(1);
    if (chkrepeat(x))
        t_error("weak seed %d, exact repeats\n", seed);
    else
        TESTCASE(1);
    if (chkones(x))
        t_error("weak seed %d, or pattern: 0x%08x\n", seed, orx);
    else
        TESTCASE(1);
}

int test_random_r_tests()
{
    long x[100];
    long y,z;
    int result;
    int i;
    struct random_data data;
    char state1[128];
    char state2[128];
    uint32_t random_value;
    char *p;
    char *q;

    result = initstate_r(1, state1, sizeof state1, &data);
    TESTCASE_MESSAGE(result == 0, "initstate_r(1, %p, %d, %p) returned %d expected 0",
        state1, sizeof state1, &data, result);
    for (i = 0; i < 100; i++) {
        result = random_r(data, &random_value);
        TESTCASE_MESSAGE(result == 0, "random_r(%p, %p) returned %d expected 0",
                &data, &random_value, result);
        x[i] = (long) random_value;
    }
    result = initstate_r(1, state2, sizeof state2, &data);
    TESTCASE_MESSAGE(result == 0, "initstate_r(1, %p, %d, %p) returned %d expected 0",
        state2, sizeof state2, &data, result);
    for (i = 0; i < 100; i++) {
        result = random_r(data, &random_value);
        TESTCASE_MESSAGE(result == 0, "random_r(%p, %p) returned %d expected 0",
                &data, &random_value, result);
        y = (long) random_value;
        TESTCASE_MESSAGE(x[i] == y, "second run with same starting point is not the same (i=%d) first: %ld, current: %ld\n",
            i, x[i], y);
    }
    p = state1;
    q = state2;
    for (i = 0; i < 10; i++) {
        result = random_r(data, &random_value);
        TESTCASE_MESSAGE(result == 0, "random_r(%p, %p) returned %d expected 0",
                &data, &random_value, result);
        z = (long) random_value;

        result = setstate_r(p, &data);
        TESTCASE_MESSAGE(result == 0, "setstate_r(%p, %p) returned %d expected 0",
            p, &data, result);

        result = random_r(data, &random_value);
        TESTCASE_MESSAGE(result == 0, "random_r(%p, %p) returned %d expected 0",
                &data, &random_value, result);
        y = (long) random_value;

        TESTCASE_MESSAGE(z != y, "setstate failed (%d) orig: %ld, reset: %ld\n", i, z, y);

        result = setstate_r(q, &data);
        TESTCASE_MESSAGE(result == 0, "setstate_r(%p, %p) returned %d expected 0",
            q, &data, result);
    }

    result = srandom_r(1, &data);
    TESTCASE_MESSAGE(result == 0, "srandom_r(1, %p) returned %d expected 0", &data, result);

    for (i = 0; i < 100; i++) {
        result = random_r(data, &random_value);
        TESTCASE_MESSAGE(result == 0, "random_r(%p, %p) returned %d expected 0",
                &data, &random_value, result);
        y = (long) random_value;

        TESTCASE_MESSAGE(x[i] != y, "random_r() srandom_r(1, &data) is not default x[%d]: %ld, reset: %ld\n", i, x[i], y);
    }

    checkseed(0x7fffffff, x);
    for (i = 0; i < 10; i++)
        checkseed(i, x);
    return t_status;
}
