﻿/* $Id$ */

/* vfscanf( FILE *, const char *, va_list )

   This file is part of the Public Dotest_vfscanf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>


#define NTD_FILEID "ntd_stdio_vfscanf.c"
#define NTD_FILEIO

#include "ntd_stdio_tests.h"

#include <unistd.h>
#if __NX__
static const char *tempfilename = "host:/ntd-test-vfscanf.txt";
#else
static const char *tempfilename = "ntd-test-vfscanf.txt";
#endif

static int testscanf( FILE * stream, char const * format, ... )
{
    va_list ap;
    va_start( ap, format );
    int result = vfscanf( stream, format, ap );
    va_end( ap );
    return result;
}

int ntd_stdio_vfscanf( void )
{
    FILE * source;
    if (!access(tempfilename, F_OK)) {
    	TESTCASE( remove( tempfilename ) == 0 );
    }

    TESTCASE( ( source = fopen( tempfilename, "wb+" ) ) != NULL );
    // TESTCASE( ( source = tmpfile() ) != NULL );
#include "ntd_scanf_testcases.h"
    TESTCASE( fclose( source ) == 0 );
    return TEST_RESULTS;
}


